/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reservations;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ordermate.database.integration.RDConfiguration;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.guikit.NavBar;

class ReservationsNav
extends NavBar
implements ActionListener {
    private StandardSecurityDecorator addButton;
    private JButton addJButton;
    private JButton walkinJButton;
    private StandardSecurityDecorator printButton;
    private JButton printJButton;
    private JLabel patronsLabel;
    public final Signal addReservation = Signals.createSignal();
    public final Signal addWalkIn = Signals.createSignal();
    public final Signal printReservations = Signals.createSignal();

    public ReservationsNav() {
        this.setText("Reservations");
        this.patronsLabel = new JLabel("");
        this.addLeft(this.getBackButton());
        this.addLeft(this.patronsLabel);
        this.printJButton = this.constructButton(IconLoader.get((String)"/waitermate/guikit/images/print.png"), "<html>Print Unallocated<br>Reservations</html>", "printsReservations");
        this.printButton = new StandardSecurityDecorator((JComponent)this.printJButton, AllPermissions.EDIT_RESERVATIONS);
        this.addRight((Component)this.printButton);
        this.addJButton = this.constructButton(IconLoader.get((String)"/waitermate/images/addReservation.png"), "Add Reservation", "addReservation");
        this.addRight(this.addJButton);
        this.walkinJButton = this.constructButton(IconLoader.get((String)"/waitermate/images/addReservation.png"), "Walk-In", "addWalkIn");
        this.addRight(this.getOkButton());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.addJButton) {
            this.addReservation.emit();
        } else if (e.getSource() == this.walkinJButton) {
            this.addWalkIn.emit();
        } else if (e.getSource() == this.printJButton) {
            this.printReservations.emit();
        }
    }

    public void refreshAddButtonView(boolean b) {
        this.addJButton.setVisible(!RDConfiguration.checkConfigured());
        boolean addEnabled = LoginManager.getInstance().getUser() == null ? false : (LoginManager.getInstance().getUser().hasPermission(AllPermissions.EDIT_RESERVATIONS) ? b : false);
        this.addJButton.setEnabled(addEnabled);
        this.walkinJButton.setEnabled(addEnabled);
    }

    public void setPatronsText(int numPatrons) {
        this.patronsLabel.setText("          Total " + Internationalization.getLiteralFor((String)"COVERS") + ": " + numPatrons);
    }
}

