/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reservations;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.HtmlUtils;
import java.util.Date;
import java.util.List;
import ordermate.database.integration.RDConfiguration;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.ReservationWarnType;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.tables.LogicalTable;
import ordermate.gui.reservation.ReservationUtils;
import ordermate.integration.ReservationIntegrationUtils;
import ordermate.integration.reservations.ReservationIntegrator;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.screens.reservations.ReservationDurationSelector;
import waitermate.guikit.dialogs.Dialogs;

public class WMReservationUtils {
    private static final int DEFAULT_DURATION = 15;
    private final ReservationUtils utils = new ReservationUtils((GuiHandler)new WaitermateGuiHandler());

    public int determineDuration(LogicalTable table) {
        int durationSelectionStatus = DurationSelectionStatus.UNSELECTABLE.getStatusCode();
        if (this.determinShowWarning()) {
            durationSelectionStatus = this.showWarningPopupWindow();
        }
        if (this.utils.isTableSelectable(table)) {
            ReservationIntegrator.ReservationTwoWay level = ReservationIntegrationUtils.getTwoWayIntegration();
            if (ReservationIntegrator.ReservationTwoWay.Explicit.equals((Object)level)) {
                List durationOptions;
                Reservation nextReservation = this.utils.getNextReservation(table);
                String nextReservationMsg = "";
                if (nextReservation != null) {
                    nextReservationMsg = HtmlUtils.html((String)("The next booking on Table " + HtmlUtils.boldColor((String)nextReservation.getTables(), (String)"green") + " is at " + HtmlUtils.boldColor((String)nextReservation.getTimeString(), (String)"green")));
                }
                int duration = 15;
                if (RDConfiguration.checkConfigured()) {
                    duration = this.utils.getRDContext().getTimeSlotInterval(new Date());
                }
                if ((durationOptions = ReservationsHelper.getDurationTimeOptions((Reservation)nextReservation, (int)duration)).isEmpty()) {
                    Dialogs.displayOkDialog((String)nextReservationMsg, (String)"Cannot Open Table - Reserved");
                    durationSelectionStatus = DurationSelectionStatus.NOT_SELECTED.getStatusCode();
                } else {
                    ReservationDurationSelector durationSelector = new ReservationDurationSelector();
                    durationSelectionStatus = durationSelector.select(durationOptions, nextReservationMsg);
                }
            } else if (ReservationIntegrator.ReservationTwoWay.Implied.equals((Object)level)) {
                durationSelectionStatus = DurationSelectionStatus.UNSELECTABLE.getStatusCode();
            }
        } else {
            durationSelectionStatus = DurationSelectionStatus.NOT_SELECTED.getStatusCode();
        }
        return durationSelectionStatus;
    }

    private int showWarningPopupWindow() {
        if (Dialogs.displayChoiceDialog((String)"<html><b>Warning:</b> Tables opened in WaiterMate will <b>not</b> be linked with your reservations system.<br><br> It is recommended you use the reservations system to open the table first.</html>", (String)"Continue anyway?", (boolean)true)) {
            return DurationSelectionStatus.UNSELECTABLE.getStatusCode();
        }
        return DurationSelectionStatus.NOT_SELECTED.getStatusCode();
    }

    private boolean determinShowWarning() {
        if (ReservationWarnType.ALWAYS_ASK.equals((Object)SystemProperty.getInstance().getReservationWarn())) {
            return true;
        }
        if (ReservationWarnType.NEVER_ASK.equals((Object)SystemProperty.getInstance().getReservationWarn())) {
            return false;
        }
        return ReservationWarnType.ASK_IF_INTEGRATED.equals((Object)SystemProperty.getInstance().getReservationWarn()) && ReservationIntegrationUtils.isCloudReservationsConfigured();
    }

    public static enum DurationSelectionStatus {
        UNSELECTABLE(0),
        NOT_SELECTED(-1);

        final int statusCode;

        private DurationSelectionStatus(int status) {
            this.statusCode = status;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

