/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reservations.addreservation;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Time;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import ordermate.database.RequiredFields;
import ordermate.database.integration.RDConfiguration;
import ordermate.database.queries.tables.LogicalTableQueries;
import ordermate.database.queries.tables.TableGroupQueries;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.gui.button.CustomButton;
import ordermate.gui.keyboard.Keyboard;
import ordermate.gui.reservation.ReservationUtils;
import ordermate.integration.ReservationIntegrationUtils;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.dialogs.DateSelectDialog;
import waitermate.gui.dialogs.TimeSelectDialog;
import waitermate.gui.mandatory.ButtonMandatoryFieldsPanel;
import waitermate.gui.screens.reservations.addreservation.SectionSelectDialog;
import waitermate.gui.screens.selectaccount.table.TableAccountSelection;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class AddReservationPanel
extends ButtonMandatoryFieldsPanel
implements ActionListener {
    private JLabel customerNameLabel;
    private JLabel customerName;
    private JLabel customerPhoneNumberLabel;
    private JLabel customerPhoneNumber;
    private JLabel dateLabel;
    private JLabel idLabel;
    private JLabel timeLabel;
    private JLabel sectionLabel;
    private JLabel patronsLabel;
    private JLabel tableLabel;
    private JButton date;
    private JButton time;
    private JButton section;
    private JButton patrons;
    private JButton table;
    private JLabel id;
    private Date currentDate;
    private Date currentTime;
    private JLabel commentsLabel;
    private JLabel comments;
    private Keyboard theKeyboard;
    public final Signal dateUpdated = Signals.createSignal(Date.class, (String)"date");
    public final Signal timeUpdated = Signals.createSignal(Time.class, (String)"time");
    public final Signal sectionUpdated = Signals.createSignal(TableGroup.class, (String)"section");
    public final Signal tableUpdated = Signals.createSignal(LogicalTable.class, (String)"table");
    public final Signal patronsUpdated = Signals.createSignal(Integer.class, (String)"patrons");
    public final Signal commentsUpdated = Signals.createSignal(String.class, (String)"comments");
    SectionSelectDialog sectionSelect;
    DateSelectDialog dateSelect;
    TimeSelectDialog timeSelect;
    private TableAccountSelection tableSelect;
    private PopupWindow tableSelectPopup = new PopupWindow();
    private Reservation currentReservation;
    private final ReservationUtils reservationUtils = new ReservationUtils((GuiHandler)new WaitermateGuiHandler());
    private boolean sectionRequired;
    private boolean patronsRequired;

    public AddReservationPanel() {
        super((LayoutManager)new GraphPaperLayout(new Dimension(20, 50)));
        this.customerName = new JLabel("");
        this.customerNameLabel = new JLabel("Customer Name");
        this.customerPhoneNumber = new JLabel("");
        this.customerPhoneNumberLabel = new JLabel("Phone Number");
        this.date = new JButton("");
        this.dateLabel = new JLabel("Date");
        this.id = new JLabel("");
        this.id.setName("id-label");
        this.idLabel = new JLabel("Booking ID");
        this.time = new JButton("");
        this.time.setName("time");
        this.timeLabel = new JLabel("Time");
        this.section = new JButton("");
        this.section.setName("section");
        this.sectionLabel = new JLabel("Section");
        this.table = new JButton("");
        this.table.setName("table");
        this.tableLabel = new JLabel("Table");
        this.patrons = new JButton("");
        this.patrons.setName("patrons");
        this.patronsLabel = new JLabel(Internationalization.getLiteralFor((String)"COVERS"));
        this.comments = new JLabel("");
        BorderUIResource blackLineBorder = new BorderUIResource(new LineBorder(Color.BLACK));
        this.comments.setBorder(blackLineBorder);
        this.comments.setHorizontalAlignment(0);
        this.commentsLabel = new JLabel("Comments");
        this.date.addActionListener(this);
        this.time.addActionListener(this);
        this.section.addActionListener(this);
        this.table.addActionListener(this);
        this.patrons.addActionListener(this);
        this.theKeyboard = new Keyboard(false, false, false);
        this.theKeyboard.updated.connect((Object)this, "keyboardUpdated");
        this.add((Component)this.customerNameLabel, new Rectangle(1, 2, 8, 2));
        this.add((Component)this.customerName, new Rectangle(4, 1, 8, 4));
        this.add((Component)this.customerPhoneNumberLabel, new Rectangle(12, 2, 3, 2));
        this.add((Component)this.customerPhoneNumber, new Rectangle(15, 1, 3, 4));
        if (!ReservationIntegrationUtils.isCloudReservationsConfigured()) {
            this.setupNoCloud();
        } else {
            this.setupCloud();
        }
        this.add((Component)this.commentsLabel, new Rectangle(1, 11, 18, 2));
        this.add((Component)this.comments, new Rectangle(1, 13, 18, 10));
        this.add((Component)this.theKeyboard, new Rectangle(0, 26, 21, 28));
        this.sectionSelect = new SectionSelectDialog();
        this.dateSelect = new DateSelectDialog();
        this.timeSelect = new TimeSelectDialog();
        this.tableSelect = new TableAccountSelection(false, false);
        this.tableSelect.tableSelected.connect((Object)this, "gotTableNames");
        this.tableSelectPopup.getNavBar().getOkButton().setVisible(false);
        this.theKeyboard.clear();
    }

    private void setupCloud() {
        this.add((Component)this.idLabel, new Rectangle(1, 5, 6, 2));
        this.add((Component)this.id, new Rectangle(1, 7, 6, 4));
        this.add((Component)this.dateLabel, new Rectangle(8, 5, 2, 2));
        this.add((Component)this.date, new Rectangle(8, 7, 2, 4));
        this.add((Component)this.timeLabel, new Rectangle(10, 5, 2, 2));
        this.add((Component)this.time, new Rectangle(10, 7, 2, 4));
        this.add((Component)this.sectionLabel, new Rectangle(13, 5, 2, 2));
        this.add((Component)this.section, new Rectangle(13, 7, 2, 4));
        this.add((Component)this.tableLabel, new Rectangle(15, 5, 2, 2));
        this.add((Component)this.table, new Rectangle(15, 7, 2, 4));
        this.add((Component)this.patronsLabel, new Rectangle(18, 5, 1, 2));
        this.add((Component)this.patrons, new Rectangle(18, 7, 1, 4));
    }

    private void setupNoCloud() {
        this.add((Component)this.dateLabel, new Rectangle(1, 5, 4, 2));
        this.add((Component)this.date, new Rectangle(1, 7, 4, 4));
        this.add((Component)this.timeLabel, new Rectangle(6, 5, 3, 2));
        this.add((Component)this.time, new Rectangle(6, 7, 3, 4));
        this.add((Component)this.sectionLabel, new Rectangle(10, 5, 2, 2));
        this.add((Component)this.section, new Rectangle(10, 7, 2, 4));
        this.add((Component)this.tableLabel, new Rectangle(13, 5, 3, 2));
        this.add((Component)this.table, new Rectangle(13, 7, 3, 4));
        this.add((Component)this.patronsLabel, new Rectangle(17, 5, 2, 2));
        this.add((Component)this.patrons, new Rectangle(17, 7, 2, 4));
    }

    public void updateDisplay(Date theDate, Date theTime, String theSection, int thePatrons, String theComments, String theTable, Reservation reservation) {
        this.currentDate = theDate;
        this.date.setText(DateTimeUtils.getMediumDateFormat().format(theDate));
        if (reservation != null) {
            this.id.setText(reservation.getExternalId());
        }
        this.currentTime = theTime;
        this.time.setText(DateTimeUtils.convertToTwelveHourTime((Date)theTime));
        this.section.setText(theSection);
        this.table.setText(theTable);
        this.patrons.setText("" + thePatrons);
        this.comments.setText("<html>" + theComments + "</html>");
        this.resetKeyboard(theComments);
        this.currentReservation = reservation;
        this.doRequiredFieldsVisualFeedback();
    }

    void keyboardUpdated(String newValue) {
        this.commentsUpdated.emit((Object)newValue);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.date) {
            boolean result = this.dateSelect.go(this.currentDate);
            if (result) {
                this.currentDate = this.dateSelect.getNewDate();
                this.dateUpdated.emit((Object)this.currentDate);
            }
        } else if (e.getSource() == this.time) {
            boolean result = this.timeSelect.go(this.currentTime);
            if (result) {
                boolean tableSelectable = true;
                if (RDConfiguration.checkConfigured()) {
                    Date newLeaveTime = DateTimeUtils.addTime((Date)this.timeSelect.getNewTime(), (int)12, (int)this.getDuration());
                    tableSelectable = this.reservationUtils.isTableSelectable(this.table.getText(), TableGroupQueries.getTableGroupByName((String)this.section.getText()), this.currentDate, (Date)this.timeSelect.getNewTime(), newLeaveTime, this.currentReservation);
                }
                if (tableSelectable) {
                    this.currentTime = this.timeSelect.getNewTime();
                    this.timeUpdated.emit((Object)this.currentTime);
                }
            }
        } else if (e.getSource() == this.section) {
            JButton selectedButton = this.sectionSelect.start();
            if (selectedButton != null) {
                CustomButton newSection = (CustomButton)selectedButton;
                this.sectionUpdated.emit((Object)newSection.getData());
            }
        } else if (e.getSource() == this.table) {
            this.doTableSelect();
        } else if (e.getSource() == this.patrons) {
            int startingInt = 0;
            try {
                startingInt = Integer.parseInt(this.patrons.getText());
            }
            catch (NumberFormatException newSection) {
                // empty catch block
            }
            int result = Dialogs.getInteger((String)(Internationalization.getLiteralFor((String)"NUMBER_OF_COVERS") + ": "), (int)startingInt);
            if (result != Integer.MIN_VALUE) {
                this.patrons.setText("" + result);
                this.patronsUpdated.emit((Object)result);
            }
        }
        this.refreshOkButton();
    }

    private void doTableSelect() {
        this.tableSelect.setTableGroup(TableGroupQueries.getTableGroupByName((String)this.section.getText()));
        this.tableSelect.setDisplayLastTableAccessedText(false);
        this.tableSelect.getNavBar().setText("Select table for reservation");
        this.tableSelectPopup.setComponent(this.tableSelect.getMainArea());
        this.tableSelectPopup.start();
    }

    public void setCustomerDetails(String name, String phone) {
        this.customerName.setText("<html><h2>" + name + "<html></h2>");
        this.customerPhoneNumber.setText("<html><h2>" + phone + "<html></h2>");
    }

    public void resetKeyboard(String value) {
        this.theKeyboard.setValue(value);
        if (value.equalsIgnoreCase("")) {
            this.theKeyboard.setCaps(true);
        }
    }

    public boolean refreshOkButton() {
        int patronsInt = 0;
        try {
            patronsInt = Integer.parseInt(this.patrons.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.doRequiredFieldsVisualFeedback();
        return !this.date.getText().equalsIgnoreCase("") && !this.time.getText().equalsIgnoreCase("") && patronsInt != 0 && !this.section.getText().equalsIgnoreCase("");
    }

    @Override
    public void reset() {
        this.customerName.setText("");
        this.customerPhoneNumber.setText("");
        this.id.setText("");
        this.date.setText("");
        this.time.setText("");
        this.section.setText("");
        this.table.setText("");
        this.patrons.setText("");
        this.comments.setText("");
    }

    public void enableButtons(boolean enable) {
        this.date.setEnabled(enable);
        this.time.setEnabled(enable);
        this.section.setEnabled(enable);
        this.table.setEnabled(enable);
        this.patrons.setEnabled(enable);
        this.theKeyboard.enableKeys(enable);
        this.finalizeView();
    }

    public void finalizeView() {
        if (RDConfiguration.checkConfigured()) {
            this.section.setEnabled(false);
        } else {
            this.table.setEnabled(false);
        }
    }

    @Override
    protected void doRequiredFieldsVisualFeedback() {
        this.paintComponentAsRequired(this.section, this.isRequirementMet(this.section));
        this.paintComponentAsRequired(this.patrons, this.isRequirementMet(this.patrons));
    }

    @Override
    public boolean isFieldsRequired() {
        return this.isSectionRequired() || this.isPatronsRequired();
    }

    public void setFieldsRequired(boolean bFieldsRequired) {
        this.setSectionRequired(bFieldsRequired);
        this.setPatronsRequired(bFieldsRequired);
    }

    void setSectionRequired(boolean SectionRequired) {
        this.sectionRequired = SectionRequired;
    }

    boolean isSectionRequired() {
        return this.sectionRequired;
    }

    void setPatronsRequired(boolean PatronsRequired) {
        this.patronsRequired = PatronsRequired;
    }

    boolean isPatronsRequired() {
        return this.patronsRequired;
    }

    @Override
    public boolean hasPanelMetRequirements() {
        return !(!this.isRequirementMet(this.patrons) && this.isPatronsRequired() || !this.isRequirementMet(this.section) && this.isSectionRequired());
    }

    @Override
    protected boolean isRequirementMet(AbstractButton button) {
        if (button == this.patrons) {
            try {
                return button.getText() != null && !button.getText().equalsIgnoreCase("") && Integer.valueOf(button.getText()) > 0;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (button == this.section) {
            return super.isRequirementMet(button);
        }
        return false;
    }

    @Override
    protected RequiredFields getRequiredObject() {
        return null;
    }

    @Override
    protected void setSelectedButton(AbstractButton button) {
        if (button != null) {
            this.theKeyboard.setValue(button.getText());
        } else {
            this.theKeyboard.setValue("");
        }
        if (this.theKeyboard.getValue().equalsIgnoreCase("") || this.theKeyboard.getValue() == null) {
            this.theKeyboard.setCaps(true);
            this.theKeyboard.setShift(true);
        }
    }

    public void gotTableNames(LogicalTable logicalTable) {
        String tableNames;
        if (this.reservationUtils.isTableSelectable(logicalTable, this.currentReservation) && this.reservationUtils.isTableSelectable(tableNames = LogicalTableQueries.getTableNames((LogicalTable)logicalTable), logicalTable.getTableGroup(), this.currentDate, this.currentTime, this.currentReservation.getLeaveTime(), this.currentReservation)) {
            this.tableSelectPopup.getNavBar().ok.emit();
            this.table.setText(tableNames);
            this.section.setText(logicalTable.getTableGroup().getName());
            this.tableUpdated.emit((Object)logicalTable);
        }
    }

    private int getDuration() {
        return (int)((this.currentReservation.getLeaveTime().getTime() - this.currentTime.getTime()) / 60000L);
    }

    public void setTimeMinuteChange() {
        if (RDConfiguration.checkConfigured() && this.reservationUtils.getRDContext() != null) {
            this.timeSelect.setMinuteChange(this.reservationUtils.getRDContext().getTimeSlotInterval(this.currentTime));
        }
    }
}

