/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.hardware.Terminal;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.search.AbstractWaitermateSearchPanel;

public class WaitermateSearchPanel
extends JPanel {
    public Signal selected;
    public Signal edit;
    private RendererScrollPaneModel model;
    private CustomScrollPane scrollPane;
    private AbstractWaitermateSearchPanel fieldPanel;
    private Renderer renderer;

    public WaitermateSearchPanel(AbstractWaitermateSearchPanel keyboardPanel, AbstractWaitermateSearchPanel touchScreenPanel, String leftPanelTitle, String rightPanelTitle, RendererScrollPaneModel scrollModel, String emptyResultsTxt, Class objectType) {
        this.fieldPanel = !Terminal.getLocalHost().isUseOnscreenKeyboard() ? keyboardPanel : touchScreenPanel;
        this.setModel(scrollModel, emptyResultsTxt);
        this.createLeftPanel(leftPanelTitle);
        this.createRightPanel(rightPanelTitle);
        this.setLayout(new GridLayout(1, 2, 2, 0));
        this.selected = Signals.createSignal((Class)objectType, (String)"selected");
        this.edit = Signals.createSignal();
    }

    private void createLeftPanel(String leftPanelTitle) {
        JPanel left = new JPanel();
        left.setLayout(new BorderLayout(0, 1));
        left.add("West", this.fieldPanel);
        JLabel label = new JLabel(Internationalization.getLiteralFor((String)leftPanelTitle));
        label.setFont(OrderMateTheme.getLargeFont());
        left.add("North", label);
        this.add((Component)left, new Rectangle(0, 0, 1, 1));
    }

    private void createRightPanel(String rightPanelTitle) {
        JPanel right = new JPanel();
        right.setLayout(new BorderLayout(0, 5));
        right.add("Center", (Component)this.scrollPane);
        JLabel label = new JLabel(Internationalization.getLiteralFor((String)rightPanelTitle));
        label.setFont(OrderMateTheme.getLargeFont());
        right.add("North", label);
        this.add(right);
    }

    public void setRenderer(Renderer objectRenderer) {
        this.renderer = objectRenderer;
    }

    private void setModel(RendererScrollPaneModel scrollPaneModel, String emptyResultsTxt) {
        this.model = scrollPaneModel;
        this.initScrollPane(emptyResultsTxt);
    }

    private void initScrollPane(String emptyResultsTxt) {
        this.scrollPane = new CustomScrollPane((CustomScrollPaneModel)this.model);
        this.scrollPane.setEmptyMessage(Internationalization.getLiteralFor((String)emptyResultsTxt));
    }

    public void connectSignals(Signal objectSelected, Signal editObject) {
        this.selected = objectSelected;
        this.edit = editObject;
    }

    public void setObjects(List objects) {
        this.model.setObjects(objects);
        this.scrollPane.displayPage(0);
    }

    public void reset() {
        this.fieldPanel.reset();
        this.model.removeAllObjects();
        this.scrollPane.displayPage(0);
    }
}

