/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.closedaccounts.viewclosedaccount.ClosedAccountItemSignals;
import waitermate.gui.screens.admin.closedaccounts.viewclosedaccount.ClosedAccountItems;
import waitermate.gui.screens.ordering.transferitems.TransferItems;
import waitermate.gui.screens.selectaccount.AccountNavBar;
import waitermate.gui.screens.selectaccount.quicksale.PreviousSalesListPanel;
import waitermate.guikit.NavBar;
import waitermate.guikit.TabScreen;
import waitermate.guikit.components.DrawerToggleButton;

public abstract class AbstractAccountSelection
extends TabScreen {
    public final Signal<Account, ?, ?, ?, ?> accountSelected = Signals.createSignal(Account.class, (String)"selectedAccount");
    protected final Signal quickTransferDone = Signals.createSignal();
    protected final Signal quickTransferAborted = Signals.createSignal();
    public final Signal showPreviousAccount = Signals.createSignal(Account.class, (String)"account");
    private DrawerToggleButton previousSales;
    private final ClosedAccountItemSignals signals = new ClosedAccountItemSignals();

    protected void setupNavForQuickTransfer(AccountNavBar nav) {
        nav.quickTransfer.connect((Object)this, "gotQuickTransfer");
        this.quickTransferAborted.connect((Object)this, "gotQuickTransferAborted");
        this.quickTransferDone.connect((Object)this, "gotQuickTransferDone");
    }

    public synchronized void gotSourceAccountBack() {
        this.display();
    }

    public synchronized void gotQuickTransferDone() {
        this.display();
    }

    protected abstract List<AccountType> getAccountTypes();

    protected List<Terminal> getTerminals() {
        return Collections.EMPTY_LIST;
    }

    public synchronized void gotQuickTransferAborted() {
        this.display();
    }

    public synchronized void gotQuickTransfer() {
        TransferItems.getInstance().startTransfer(this.getTabName(), this.quickTransferDone, this.quickTransferAborted, true);
    }

    private void addPreviousSalesToNav() {
        if (this.previousSales == null && Terminal.getLocalHost().isShowPreviousSales(this.getAccountTypes())) {
            NavBar nav = this.getNavBar();
            this.createPreviousSalesDrawerButton(nav);
            nav.addLeft(this.getPreviousSalesDrawerButton());
            this.signals.back.connect((Object)this, "showPreviousAccountDone");
            this.signals.ok.connect((Object)this, "showPreviousAccountDone");
        }
    }

    public Component getPreviousSalesDrawerButton() {
        return this.previousSales;
    }

    private void createPreviousSalesDrawerButton(NavBar nav) {
        this.previousSales = nav.constructDrawerToggleButton("Previous Sales", IconLoader.get((String)"/waitermate/images/selectItemsUp.png"), IconLoader.get((String)"/waitermate/images/selectItemsDown.png"));
        List terminals = SystemProperty.getInstance().isPreviousSalesLocalTerminalOnly() ? Terminal.getLocalHost().getLocation().getTerminals() : this.getTerminals();
        final PreviousSalesListPanel previousSalesListPanel = new PreviousSalesListPanel(this.getAccountTypes(), terminals);
        previousSalesListPanel.accountSelected.connect((Object)this, "gotShowPreviousAccount");
        this.previousSales.setDrawer((JComponent)previousSalesListPanel);
        this.previousSales.setName("previousSales");
        this.previousSales.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                previousSalesListPanel.updateList(AbstractAccountSelection.this.previousSales.isSelected());
            }
        });
        StandardSecurityDecorator prevSalesDec = new StandardSecurityDecorator((JComponent)this.previousSales, AllPermissions.VIEW_PREVIOUS_SALES);
    }

    public void setUp() {
        this.addPreviousSalesToNav();
        super.setUp();
    }

    public void gotShowPreviousAccount(Account accountToShow) {
        this.showPreviousAccount(accountToShow);
        this.previousSales.closeDrawer();
    }

    public void showPreviousAccount(Account account) {
        if (account != null) {
            ClosedAccountItems instance = ClosedAccountItems.getInstance(this.signals);
            instance.getNavBar().getOkButton().setVisible(false);
            instance.startSelectItems(account);
        }
    }

    public void showPreviousAccountDone() {
        this.display();
    }
}

