/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount;

import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.Lockable;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalMode;
import ordermate.database.misc.BarcodeUtils;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.sales.Account;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.database.workflow.AccountRedemptionResultStringifier;
import ordermate.database.workflow.WorkflowAccountScanRedemptionResult;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.services.sales.WorkflowBarcodeExecutable;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.WaitermateAccountGui;
import waitermate.gui.overview.WaiterMateOverview;
import waitermate.gui.screens.debtor.SelectDebtorTabScreen;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.ordering.transferitems.TransferItems;
import waitermate.gui.screens.reservations.WMReservationUtils;
import waitermate.gui.screens.selectaccount.OnlineAccountSniffer;
import waitermate.gui.screens.selectaccount.online.OnlineAccountSelection;
import waitermate.gui.screens.selectaccount.phone.PhoneSelection;
import waitermate.gui.screens.selectaccount.phone.drivers.DriversScreen;
import waitermate.gui.screens.selectaccount.quicksale.QuickSale;
import waitermate.gui.screens.selectaccount.quicksale.QuickSaleController;
import waitermate.gui.screens.selectaccount.table.CoversHelper;
import waitermate.gui.screens.selectaccount.table.TableAccountSelection;
import waitermate.gui.screens.selectaccount.table.TableAccountSelectionNav;
import waitermate.gui.screens.selectaccount.takeaway.DriveThruSelection;
import waitermate.gui.screens.selectaccount.takeaway.TakeawaySelection;
import waitermate.gui.screens.selectaccount.takeaway.bartabs.BarTabSelection;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.CompositeScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.SignalEmittingTimer;
import waitermate.guikit.TabScreen;
import waitermate.guikit.dialogs.Dialogs;

public class SelectAccount
extends CompositeScreen
implements PropertyChangeListener {
    private static final long ONLINE_SNIFFER_DELAY = 5000L;
    private static final int FORCE_LOGOUT_TIME = 14400;
    private static final long FLASH_DELAY = 500L;
    private static final Color FLASH_COLOUR = Color.RED;
    private static CoversHelper coversHelperPrototype;
    public Signal back = Signals.createSignal();
    public Signal admin = Signals.createSignal();
    public final Signal<Account, ?, ?, ?, ?> accountSelected = Signals.createSignal(Account.class, (String)"account");
    public final Signal<List, Account, ?, ?, ?> accountsSelected = Signals.createSignal(List.class, (String)"theAccounts", Account.class, (String)"selectedAccount");
    public final Signal reservations = Signals.createSignal();
    public final Signal<TabScreen, ?, ?, ?, ?> tabChange = Signals.createSignal(TabScreen.class, (String)"selectedState");
    private QuickSaleController quickSaleController;
    public final Signal<Long, ?, ?, ?, ?> gotNewOnlineOrders = Signals.createSignal(Long.class, (String)"numberOfOrders");
    protected TableAccountSelection tables;
    private OnlineAccountSelection online;
    private DriversScreen deliveryDrivers;
    private SignalEmittingTimer logoutTimer;
    private boolean shouldSelectOnlineOrders = false;
    private Timer flashOnlineOrdersTimer;
    private boolean selectMulti = true;
    private final WMReservationUtils reservationUtils = new WMReservationUtils();

    public SelectAccount() {
        this.initScreens(Terminal.getLocalHost().isUnallocatedTableAllowed());
    }

    public void setCanSelectMultipleAccounts(boolean value) {
        this.selectMulti = value;
    }

    protected void initScreens(boolean isUnallocatedTables) {
        Terminal myTerminal = Terminal.getLocalHost();
        for (TerminalMode mode : myTerminal.getTerminalModes()) {
            NavBar nav;
            PhoneSelection phone;
            if (mode.getMode().equals("Tables")) {
                TableAccountSelection tableScreen = this.createTableSelectionScreen(mode, isUnallocatedTables);
                tableScreen.tableSelectionScreenChanged.connect((Object)this, "gotTableSelectionScreenChanged");
                continue;
            }
            if (mode.getMode().equals("Phone")) {
                phone = new PhoneSelection(false);
                this.addGuiState(phone, mode.getLabel());
                phone.accountSelected.connect((Object)this, "gotAccount");
                nav = phone.getNavBar();
                this.setupNavBar(nav);
                continue;
            }
            if (mode.getMode().equals("Phone with Delivery")) {
                phone = new PhoneSelection(true);
                this.addGuiState(phone, mode.getLabel());
                phone.accountSelected.connect((Object)this, "gotAccount");
                nav = phone.getNavBar();
                this.setupNavBar(nav);
                continue;
            }
            if (mode.getMode().equals("Takeaway")) {
                TakeawaySelection takeaway = new TakeawaySelection();
                this.addGuiState(takeaway, mode.getLabel());
                takeaway.accountSelected.connect((Object)this, "gotAccount");
                nav = takeaway.getNavBar();
                this.setupNavBar(nav);
                continue;
            }
            if (mode.getMode().equals("Drive Thru")) {
                DriveThruSelection driveThru = new DriveThruSelection();
                this.addGuiState(driveThru, mode.getLabel());
                driveThru.accountSelected.connect((Object)this, "gotAccount");
                nav = driveThru.getNavBar();
                this.setupNavBar(nav);
                continue;
            }
            if (mode.getMode().equals("Quick Sale")) {
                if (this.quickSaleController == null) {
                    this.quickSaleController = QuickSaleController.init(this);
                }
                QuickSaleController.getInstance().createQuickSale(mode);
                continue;
            }
            if (mode.getMode().equals("Bar Tabs")) {
                BarTabSelection barTabs = new BarTabSelection(true);
                this.addGuiState(barTabs, mode.getLabel());
                barTabs.accountSelected.connect((Object)this, "gotAccount");
                WaiterMateInputAdapter.getInstance().customerCardInput.connect((Object)barTabs, "gotCustomerCard");
                nav = barTabs.getNavBar();
                this.setupNavBar(nav);
                continue;
            }
            if (mode.getMode().equals("Debtors")) {
                SelectDebtorTabScreen debtorSelection = SelectDebtorTabScreen.getInstance();
                this.addGuiState(debtorSelection, mode.getLabel());
                nav = debtorSelection.getNavBar();
                nav.admin.connect((Object)this.admin, "emit");
                nav.logout.connect((Object)this.back, "emit");
                continue;
            }
            if (mode.getMode().equals("Online")) {
                if (!SystemProperty.getInstance().isOnlineIntegrationFull()) {
                    OrderMate.LOG.warn("Terminal has online mode but online integration system property is not enabled.");
                    continue;
                }
                this.online = new OnlineAccountSelection();
                this.addGuiState(this.online, mode.getLabel());
                this.online.accountSelected.connect((Object)this, "gotAccount");
                this.setupNavBar(this.online.getNavBar());
                OnlineAccountSniffer sniffer = new OnlineAccountSniffer();
                sniffer.onlineAccountWaiting.connect((Object)this, "gotNewOnlineOrders");
                Timer timer = new Timer("Online Orders Timer", true);
                timer.schedule((TimerTask)sniffer, 5000L, 5000L);
                continue;
            }
            if (!mode.getMode().equals("Delivery")) continue;
            this.deliveryDrivers = new DriversScreen(true);
            this.addGuiState(this.deliveryDrivers, mode.getLabel());
            Signal accSelected = Signals.createSignal(Account.class, (String)"selectedAccount");
            this.deliveryDrivers.setAccountSelectedSignal(accSelected);
            accSelected.connect((Object)this, "gotAccount");
            this.setupNavBar(this.deliveryDrivers.getNavBar());
        }
        WaiterMateInputAdapter.getInstance().accountIDInput.connect((Object)this, "gotAccountScanned");
    }

    public void gotTableSelectionScreenChanged() {
        this.resetLogoutTimer();
    }

    protected void setupNavBar(NavBar nav) {
        nav.addRight((Component)new StandardSecurityDecorator((JComponent)nav.getAdminButton(), AllPermissions.SYSTEM_ADMIN));
        nav.addRight((Component)nav.getLogoutButton());
        nav.admin.connect((Object)this.admin, "emit");
        nav.logout.connect((Object)this.back, "emit");
    }

    private TableAccountSelection createTableSelectionScreen(TerminalMode tableMode, boolean isUnallocatedTablesMode) {
        TableAccountSelection oldScreen = this.tables;
        if (oldScreen == null) {
            this.tables = new TableAccountSelection(true, isUnallocatedTablesMode);
            this.tables.setOverviewPanel(new WaiterMateOverview());
            this.tables.accountSelected.connect((Object)this, "gotAccount");
            this.tables.accountsSelected.connect((Object)this, "gotAccounts");
            this.tables.tableSelected.connect((Object)this, "gotTable");
            WaiterMateInputAdapter.getInstance().customerCardInput.connect((Object)this.tables, "gotCustomerCard");
            TableAccountSelectionNav nav = (TableAccountSelectionNav)this.tables.getNavBar();
            nav.addRight((Component)new StandardSecurityDecorator((JComponent)nav.getAdminButton(), AllPermissions.SYSTEM_ADMIN));
            nav.addRight(nav.getLogoutButton());
            nav.admin.connect((Object)this.admin, "emit");
            nav.reservations.connect((Object)this.reservations, "emit");
            nav.logout.connect((Object)this.back, "emit");
        } else {
            this.tables.init(Terminal.getLocalHost().getGtl(), isUnallocatedTablesMode);
        }
        if (oldScreen == null) {
            this.addGuiState(this.tables, tableMode.getLabel());
        }
        return this.tables;
    }

    public void startSelectAccount() {
        WaitermateAccountGui.getInstance().accountChanged(null);
        Terminal localTerminal = Terminal.getLocalHost();
        if (localTerminal.hasTableMode()) {
            this.tables.setGraphical(localTerminal.getGtl());
        }
        this.display();
        if (this.shouldSelectOnlineOrders && this.online != null) {
            this.setCurrentState(this.online);
        }
    }

    public void display() {
        if (this.getSubStates() == null || this.getSubStates().isEmpty()) {
            Dialogs.displayOkDialog((String)"There are no screens setup for waitermate to display.", (String)"No terminal modes");
            LoginManager.getInstance().logout();
        } else {
            super.display();
            this.resetLogoutTimer();
        }
    }

    public void gotAccount(Account newAccount) {
        if (this.checkForValidShift(newAccount) && WaitermateSaveAccount.getInstance().lockAccount((Lockable)newAccount)) {
            this.accountSelected.emit((Object)newAccount);
        }
    }

    public void gotAccounts(List<? extends Account> accounts, Account selectedAccount) {
        if (!this.selectMulti) {
            Dialogs.displayOkDialog((String)"Multiple Tabs cannot be selected", (String)"Table Tabs");
            return;
        }
        boolean fine = true;
        for (Account account : accounts) {
            fine = this.checkForValidShift(account);
            if (fine) continue;
            return;
        }
        if (selectedAccount != null) {
            if (WaitermateSaveAccount.getInstance().lockAccount((Lockable)selectedAccount)) {
                this.accountsSelected.emit(accounts, (Object)selectedAccount);
            }
        } else if (TransferItems.getInstance().isInTransfer()) {
            boolean allAccountsLocked = true;
            for (Account account : accounts) {
                if (account.isLocked()) continue;
                allAccountsLocked = false;
                break;
            }
            if (allAccountsLocked) {
                Dialogs.displayOkDialog((String)"All Accounts on this table are locked!", (String)"Table Tabs");
                return;
            }
            this.accountsSelected.emit(accounts, null);
        } else {
            boolean found = false;
            for (Account account : accounts) {
                if (account.isLocked() || !WaitermateSaveAccount.getInstance().lockAccount((Lockable)account)) continue;
                found = true;
                this.accountsSelected.emit(accounts, (Object)account);
                break;
            }
            if (!found) {
                this.gotAccounts(accounts, accounts.get(0));
            }
        }
    }

    private boolean checkForValidShift(Account account) {
        Shift accountShift = account.getShift();
        Shift terminalShift = Terminal.getLocalHost().getShift();
        boolean validShift = true;
        if (!accountShift.equals((Object)terminalShift)) {
            StringBuilder SB = new StringBuilder("<html>Making changes to this account will cause discrepancies<br>");
            SB.append("between Sales and Takings.<br><br>").append("This account was created on ").append(accountShift).append("<br>however it is currently ").append(terminalShift).append("<br><br>").append("If you proceed, consult the 'Sales to Takings' report for further information.<br><br>").append("Do you want to continue?");
            validShift = Dialogs.displayChoiceDialog((String)SB.toString(), (String)"Old account", (boolean)true);
            if (validShift) {
                TerminalEventLog.logTradingDayDiscrepancy((User)LoginManager.getInstance().getUser(), (Terminal)Terminal.getLocalHost(), (String)("Account " + account.getLabel() + " was created on " + accountShift + " but edited on " + terminalShift));
            }
        }
        return validShift;
    }

    public void setActiveQuickSale(QuickSale quickSale) {
        this.setCurrentState(quickSale);
    }

    protected void tabChanged() {
        WaitermateAccountGui.getInstance().accountChanged(null);
        super.tabChanged();
        this.tabChange.emit((Object)this.getCurrentState());
        this.resetLogoutTimer();
    }

    private void resetLogoutTimer() {
        if (this.logoutTimer != null) {
            this.logoutTimer.stop();
        }
        boolean startTimer = true;
        if (this.getCurrentState() instanceof QuickSale) {
            startTimer &= ((QuickSale)this.getCurrentState()).canStartLogoutTimer();
        }
        if (startTimer) {
            int time;
            User currentUser = LoginManager.getInstance().getUser();
            boolean isOrderMateGodUser = currentUser != null && currentUser.isSystemAdministrator();
            int n = time = isOrderMateGodUser ? 180 : Terminal.getLocalHost().getAutoLogoutDelay();
            if (time <= 0) {
                time = 14400;
            }
            this.logoutTimer = new SignalEmittingTimer(time, Terminal.getLocalHost().getAutoLogoutCountDown(), (AbstractScreen)this, this.back, "System will automatically logout", "Logout");
        }
    }

    public void gotTable(LogicalTable theTable) {
        if (theTable.hasAccount()) {
            TableAccount currentAccount = theTable.getAccount();
            if (currentAccount != null) {
                if (currentAccount.getNumPatrons() < 1) {
                    currentAccount.setNumPatrons(this.determinePatrons(new CoversHelper(), theTable));
                }
                currentAccount.setTable(theTable);
                this.gotAccount((Account)currentAccount);
            } else {
                List tabs = theTable.getBarTabs();
                if (!tabs.isEmpty()) {
                    this.gotAccounts(tabs, null);
                }
            }
        } else if (WaitermateSaveAccount.getInstance().lockAccount((Lockable)theTable)) {
            int duration = this.reservationUtils.determineDuration(theTable);
            if (duration == -1) {
                theTable.unlock();
                return;
            }
            CoversHelper ch = this.createCoversHelper();
            int numPatrons = this.determinePatrons(ch, theTable);
            if (numPatrons > -1) {
                User user = LoginManager.getInstance().getUser();
                Terminal localHost = Terminal.getLocalHost();
                TableAccount newAccount = new TableAccount(user, theTable, numPatrons, localHost);
                if (SystemProperty.getInstance().isCoversAndSeatsSeparated() && newAccount instanceof TableAccount) {
                    newAccount.setSeats(ch.getSeats());
                }
                newAccount.setDuration(duration);
                this.gotAccount((Account)newAccount);
            } else {
                theTable.unlock();
            }
        }
    }

    private CoversHelper createCoversHelper() {
        if (coversHelperPrototype != null) {
            return coversHelperPrototype;
        }
        return new CoversHelper();
    }

    private int determinePatrons(CoversHelper ch, LogicalTable theTable) {
        int numPatrons = 0;
        DeterminePatrons determine = SystemProperty.getInstance().getDeterminePatrons();
        if (DeterminePatrons.Gui.equals((Object)determine)) {
            try {
                ch.promptForCovers(numPatrons, theTable);
                numPatrons = ch.getCovers();
            }
            catch (Exception ex) {
                numPatrons = theTable.getNumberOfSeats();
            }
        } else if (DeterminePatrons.TableDefault.equals((Object)determine)) {
            numPatrons = theTable.getNumberOfSeats();
        }
        return numPatrons;
    }

    public void gotQuickSaleChanged(QuickSale changedScreen) {
        this.resetLogoutTimer();
    }

    public void addQuickSale(QuickSale quickSale) {
        quickSale.addPropertyChangeListener(this);
        int index = 0;
        int foundQuickSale = this.getSubStates().size();
        for (TabScreen screen : this.getSubStates()) {
            if (screen instanceof QuickSale) {
                foundQuickSale = index + 1;
                break;
            }
            ++index;
        }
        this.addGuiState(foundQuickSale, quickSale, quickSale.getTabName());
    }

    public void removeQuickSale(QuickSale quickSale) {
        quickSale.removePropertyChangeListener(this);
        if (this.getSubStates().contains((Object)quickSale)) {
            this.removeGuiState(quickSale);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("currentName")) {
            for (QuickSale screen : this.getGUIStates(QuickSale.class)) {
                if (!((Object)((Object)screen)).equals(evt.getSource())) continue;
                this.setTabName(screen, evt.getNewValue().toString());
            }
        }
    }

    void gotNewOnlineOrders(Long number) {
        if (number.intValue() > 0) {
            boolean bl = this.shouldSelectOnlineOrders = !this.isDisplaying();
            if (this.flashOnlineOrdersTimer != null) {
                this.flashOnlineOrdersTimer.cancel();
            }
            this.flashOnlineOrdersTimer = new Timer("Flash Online Orders", true);
            this.flashOnlineOrdersTimer.schedule((TimerTask)new FlashTabTask(this.online, FLASH_COLOUR), 500L, 500L);
        } else {
            this.shouldSelectOnlineOrders = false;
            if (this.flashOnlineOrdersTimer != null) {
                this.flashOnlineOrdersTimer.cancel();
                this.setTabColour(this.online, null);
            }
        }
        this.gotNewOnlineOrders.emit((Object)number);
    }

    public void setTableGroup(TableGroup group) {
        this.tables.setTableGroup(group);
    }

    public void gotAccountScanned(Long accountID) {
        if (this.isDisplaying()) {
            String barcode = BarcodeUtils.makeBarcodeString((long)accountID, (BarcodeUtils.BarcodePrefixGroup)BarcodeUtils.BarcodePrefixGroup.Account) + "0";
            WorkflowAccountScanRedemptionResult result = (WorkflowAccountScanRedemptionResult)PersistenceManager.getServerConnection().runSync((Executable)new WorkflowBarcodeExecutable(barcode, Terminal.getLocalHost().getLabel()));
            AccountRedemptionResultStringifier stringifier = new AccountRedemptionResultStringifier(result);
            if (!(this.getCurrentState() instanceof DriversScreen)) {
                Dialogs.displayOkDialog((String)("<html>" + stringifier.getInformationMessage() + "</html>"), (String)stringifier.getTitle());
            } else {
                OrderMate.LOG.info("Account redemption dialog suppressed as barcode was scanned while on DriversScreen. Response message: " + stringifier.getInformationMessage());
            }
        }
    }

    public void clearQuicksales() {
        QuickSaleController.getInstance().removeAllQuicksales();
    }

    public QuickSaleController getQSController() {
        return QuickSaleController.getInstance();
    }

    public static void setCoversHelperPrototype(CoversHelper coversHelperPrototype) {
        SelectAccount.coversHelperPrototype = coversHelperPrototype;
    }

    class FlashTabTask
    extends TimerTask {
        private final TabScreen myTab;
        private boolean changed = false;
        private final Color myColor;

        FlashTabTask(TabScreen yourTab, Color color) {
            this.myTab = yourTab;
            this.myColor = color;
        }

        @Override
        public void run() {
            if (SelectAccount.this.isDisplaying()) {
                if (this.changed) {
                    SelectAccount.this.setTabColour(this.myTab, null);
                } else {
                    SelectAccount.this.setTabColour(this.myTab, this.myColor);
                }
                this.changed = !this.changed;
            }
        }
    }
}

