/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.CompositeIconGenerator;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.GuiUtils;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import ordermate.database.Payable;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.Customer;
import ordermate.database.sales.PhoneAccount;
import ordermate.gui.scroll.renderer.DisplayableRenderer;
import ordermate.gui.themes.OrderMateTheme;

public class PhoneAccountRenderer
extends DisplayableRenderer {
    private final int NAME_DISPLAY_LENGTH = 25;
    private final int ADDRESS_DISPLAY_LENGTH = 30;
    private final String DEFAULT_FONT_SIZE = "size='-2'";

    public void setupComponent(Component component, Object object, int index) {
        PhoneAccount account = (PhoneAccount)object;
        AbstractButton button = (AbstractButton)component;
        super.setupComponent(component, object, index);
        button.setVerticalTextPosition(1);
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html>");
        this.insertHTML(buffer, account);
        buffer.append("</html>");
        button.setText(buffer.toString());
        button.setIcon(this.getIcon(account));
    }

    protected ImageIcon getIcon(PhoneAccount account) {
        String paidIcon = this.getPaidIcon(account);
        String accountTypeIcon = null;
        accountTypeIcon = account.isDeliverable() ? "/waitermate/images/house-small.png" : "/waitermate/images/phone-small.png";
        if (paidIcon != null) {
            CompositeIconGenerator generator = new CompositeIconGenerator(24, 1);
            generator.addIcon(accountTypeIcon);
            generator.addIcon(paidIcon);
            return IconLoader.get((String)generator.generateIcon());
        }
        return IconLoader.get((String)accountTypeIcon);
    }

    private String getPaidIcon(PhoneAccount account) {
        if (Payable.PAID.equals(account.getPaidState()) && !account.getFinanceTransactions().isEmpty()) {
            String type = ((FinanceTransaction)account.getFinanceTransactions().get(0)).getType();
            if ("CASH".equals(type)) {
                return "/waitermate/images/money_small.png";
            }
            if ("CREDIT".equals(type)) {
                return "/waitermate/images/ccard_small.png";
            }
            if ("DEBIT".equals(type)) {
                return "/waitermate/images/dcard_small.png";
            }
        }
        return null;
    }

    private String getCustomerName(Customer customer) {
        StringBuilder sb = new StringBuilder();
        this.appendIfNotNull(sb, customer.getFirstName());
        this.appendIfNotNull(sb, customer.getLastName());
        sb = new StringBuilder(StringUtils.shorten((String)sb.toString(), (int)25));
        sb.append(" ");
        return sb.toString();
    }

    private String getAddress(Customer customer) {
        StringBuilder buffer = new StringBuilder();
        boolean newLine = false;
        newLine |= this.appendIfNotNull(buffer, customer.getRoomAptNumber(), " /");
        newLine |= this.appendIfNotNull(buffer, customer.getHouseNumber());
        newLine |= this.appendIfNotNull(buffer, customer.getStreetName());
        newLine |= this.appendIfNotNull(buffer, customer.getStreetType());
        newLine |= this.appendIfNotNull(buffer, customer.getSuburb());
        buffer = new StringBuilder(StringUtils.shorten((String)buffer.toString(), (int)30));
        if (newLine) {
            buffer.append("<br>");
        }
        return buffer.toString();
    }

    private String addFontSize() {
        if (Config.getBooleanValue((String)"ADJUST_ADDRESS_FONT_SIZE")) {
            return "";
        }
        return "size='-2'";
    }

    protected void insertHTML(StringBuilder buffer, PhoneAccount account) {
        buffer.append("<body style=\"color:").append(GuiUtils.colorAsHex((Color)OrderMateTheme.getDefaultTextColor())).append("\">");
        buffer.append("<font ");
        buffer.append(this.addFontSize());
        buffer.append(" >");
        Customer customer = account.getCustomer();
        buffer.append(this.getCustomerName(customer)).append(DateTimeUtils.getSimpleTimeFormat().format(account.getCreationDateTime())).append("<br>");
        buffer.append(this.getAddress(customer));
        buffer.append(customer.getPrimaryPhoneNumber()).append(" ");
        buffer.append("<br>");
        this.appendDueDateTimeString(buffer, account);
        if (account.getDebtor() == null) {
            buffer.append("<br>Amount Due: ").append(account.getSummaryDue().toString(true));
        } else {
            buffer.append("<br>Amount Due: $0.00");
        }
        buffer.append("</font>");
    }

    private void appendDueDateTimeString(StringBuilder buffer, PhoneAccount account) {
        if (account.hasTimeDue()) {
            boolean addColor;
            Date dateDue = account.getDateDue();
            if (dateDue == null) {
                dateDue = new Date();
            }
            boolean bl = addColor = !dateDue.after(new Date());
            if (addColor) {
                buffer.append("<font color=\"red\"><em>");
            }
            buffer.append("Due: ").append(DateTimeUtils.getMediumDateFormat().format(dateDue)).append(" ").append(DateTimeUtils.getSimpleTimeFormat().format(account.getTimeDue()));
            if (addColor) {
                buffer.append("</em></font>");
            }
        }
    }

    private boolean appendIfNotNull(StringBuilder buffer, String value) {
        return this.appendIfNotNull(buffer, value, null);
    }

    private boolean appendIfNotNull(StringBuilder buffer, String value, String suffix) {
        boolean append;
        boolean bl = append = value != null && !value.equals("");
        if (append) {
            buffer.append(value);
            if (suffix != null) {
                buffer.append(suffix);
            }
            buffer.append(" ");
        }
        return append;
    }
}

