/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone;

import au.com.ordermate.util.image.IconLoader;
import javax.swing.JButton;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DriverAssignmentSettlementType;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.selectaccount.AccountNavBar;

public class PhoneNav
extends AccountNavBar {
    private static final String NEW_PHONE_ORDER = "New Phone Order";
    public static final String NEW_PICKUP_ORDER = "New Pickup Order";
    public static final String NEW_DELIVERY_ORDER = "New Delivery Order";
    public final Signal drivers = Signals.createSignal();
    public final Signal createNewDelivery = Signals.createSignal();
    private DriverAssignmentSettlementType dasType = DriverAssignmentSettlementType.PHONE;
    private JButton driversButton;
    private JButton createDelivery;

    public PhoneNav(boolean withDelivery) {
        this(withDelivery, DriverAssignmentSettlementType.PHONE);
    }

    public PhoneNav(boolean withDelivery, DriverAssignmentSettlementType type) {
        super(PhoneNav.getNewPhoneOrderLabel(), "/waitermate/images/phoneOrder.png");
        this.dasType = type;
        if (withDelivery) {
            if (SystemProperty.getInstance().canAssignDriver(this.dasType)) {
                if (this.driversButton != null) {
                    this.driversButton.addActionListener(Signals.createActionListener((Signal)this.drivers));
                }
            } else if (this.driversButton != null) {
                this.removeRight(this.driversButton);
                this.driversButton = null;
            }
            if (this.createDelivery != null) {
                this.createDelivery.addActionListener(Signals.createActionListener((Signal)this.createNewDelivery));
            }
        } else {
            if (this.driversButton != null) {
                this.removeRight(this.driversButton);
                this.driversButton = null;
            }
            if (this.createDelivery != null) {
                this.removeRight(this.createDelivery);
                this.createDelivery = null;
            }
        }
    }

    private static String getNewPhoneOrderLabel() {
        return Terminal.getLocalHost().hasDeliveryMode() ? NEW_PICKUP_ORDER : NEW_PHONE_ORDER;
    }

    @Override
    protected void setupComponents() {
        if (Terminal.getLocalHost().hasDeliveryMode()) {
            if (SystemProperty.getInstance().getDriverAssignmentSettlement() != DriverAssignmentSettlementType.NONE) {
                this.driversButton = this.constructButton(IconLoader.get((String)"/waitermate/images/drivers.png"), "Drivers", "drivers");
                this.addRight(this.driversButton);
            }
            this.createDelivery = this.constructButton(IconLoader.get((String)"/waitermate/images/delivery.png"), NEW_DELIVERY_ORDER, "createDelivery");
            this.addRight(this.createDelivery);
        }
        super.setupComponents();
    }

    public void setCreateDeliveryVisible(boolean visible) {
        if (this.createDelivery != null) {
            this.createDelivery.setVisible(visible);
        }
    }

    public void setDriversVisible(boolean visible) {
        if (this.driversButton != null) {
            this.driversButton.setVisible(visible);
        }
    }

    private void setInfoText(String text) {
        this.setText("<html><h3>   " + text + "<html></h3>");
    }

    public void setNumUnassignedAccounts(int num) {
        if (!SystemProperty.getInstance().canAssignDriver(this.dasType)) {
            this.setInfoText("");
            return;
        }
        if (num == 0) {
            this.setInfoText("");
        } else if (num == 1) {
            this.setInfoText(num + " unassigned Delivery Account");
        } else {
            this.setInfoText(num + " unassigned Delivery Accounts");
        }
    }
}

