/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone.drivers;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.drivertracking.DriverTrackingConfig;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.sales.PhoneAccountQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.gui.delivery.DeliveryGuiHelper;
import ordermate.gui.delivery.DeliveryHandler;
import ordermate.signals.Signal;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.screens.admin.completeddeliveries.CompletedDeliveries;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.selectaccount.phone.drivers.AutoAssignDriverSelector;
import waitermate.gui.screens.selectaccount.phone.drivers.DriversNav;
import waitermate.gui.screens.selectaccount.phone.drivers.DriversScreenI;
import waitermate.gui.screens.selectaccount.phone.drivers.DriversScreenPanel;
import waitermate.gui.screens.selectaccount.phone.drivers.UnassignedOrdersScreen;
import waitermate.gui.screens.selectaccount.phone.drivers.WMDeliveryGuiHelper;
import waitermate.gui.screens.selectaccount.phone.settle.SettleDeliveryAccounts;
import waitermate.guikit.NavBar;
import waitermate.guikit.TabScreen;
import waitermate.guikit.dialogs.AccountComments;
import waitermate.guikit.dialogs.Dialogs;

public class DriversScreen
extends TabScreen
implements DriversScreenI {
    private static DriversScreenI instance;
    private Signal<Account, ?, ?, ?, ?> accountSelected;
    private Signal screenStopped;
    private DriversScreenPanel gui;
    private DriversNav nav;
    private CompletedDeliveries completedDeliveries;
    private SettleDeliveryAccounts returnedDeliveries;
    private User currentDriver;
    private WMDeliveryGuiHelper deliveryHelper;
    UnassignedOrdersScreen unassignedOrders;

    public static DriversScreenI getDriversScreen() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must be called from EDT");
        }
        if (instance == null) {
            instance = new DriversScreen(false);
        }
        return instance;
    }

    public DriversScreen(boolean isTerminalMode) {
        this(isTerminalMode, new DriversScreenPanel(), new DriversNav(isTerminalMode), new SettleDeliveryAccounts(), new CompletedDeliveries(), new WMDeliveryGuiHelper());
    }

    protected DriversScreen(boolean isTerminalMode, DriversScreenPanel panel, DriversNav newNav, SettleDeliveryAccounts settleDeliveries, CompletedDeliveries compDeliveries, WMDeliveryGuiHelper delHelper) {
        this.gui = panel;
        this.nav = newNav;
        this.returnedDeliveries = settleDeliveries;
        this.completedDeliveries = compDeliveries;
        this.deliveryHelper = delHelper;
        if (this.nav.assign != null) {
            this.nav.assign.connect((Object)this, "gotAssign");
            this.nav.returned.connect((Object)this, "gotReturned");
            this.nav.back.connect((Object)this, "gotBack");
            this.nav.ok.connect((Object)this, "gotOk");
            this.nav.completed.connect((Object)this, "gotCompleted");
            this.nav.settle.connect((Object)this, "gotSettle");
            this.nav.print.connect((Object)this, "gotPrint");
            this.nav.autoAssign.connect((Object)this, "gotAutoAssign");
            this.nav.printDriverSummarySignal.connect((Object)this, "gotPrintDriverSummary");
            this.gui.buttonClicked.connect((Object)this, "gotButtonPressed");
            this.gui.accountSelected.connect((Object)this, "gotAccountSelected");
            this.gui.deleteClicked.connect((Object)this, "gotDelete");
            this.returnedDeliveries.stopped.connect((Object)this, "display");
            this.completedDeliveries.done.connect((Object)this, "display");
        }
        WaiterMateInputAdapter.getInstance().accountIDInput.connect((Object)this, "gotAccountID");
    }

    void gotAssign() {
        if (this.unassignedOrders == null) {
            this.unassignedOrders = new UnassignedOrdersScreen();
            this.unassignedOrders.createNewDelivery.connect((Object)this, "gotCreateNewDelivery");
            this.unassignedOrders.cancel.connect((Object)this, "display");
        }
        this.unassignedOrders.start();
    }

    void gotCreateNewDelivery(List<PhoneAccount> accounts) {
        if (accounts == null || accounts.isEmpty() || this.currentDriver == null) {
            OrderMate.LOG.warn("gotCreateNewDelivery with invalid params Accs:" + accounts + " current driver" + this.currentDriver);
            this.display();
            return;
        }
        if (this.currentDriver != LoginManager.getInstance().getUser() && !LoginManager.getInstance().hasPermission(AllPermissions.ASSIGN_DELIVERY_TO_OTHERS)) {
            Dialogs.displayOkDialog((String)"You do not have permission to assign deliveries to other drivers", (String)"Cannot assign to other drivers");
            this.display();
            return;
        }
        DeliveryHandler handler = new DeliveryHandler((DeliveryGuiHelper)this.deliveryHelper, (GuiHandler)new WaitermateGuiHandler());
        handler.handleDeliveryAssignment(accounts, this.currentDriver, LoginManager.getInstance().getUser());
        HashSet<Customer> customers = new HashSet<Customer>();
        for (Account account : accounts) {
            customers.add(account.getCustomer());
        }
        AccountComments.displayMultiCustomerComment(customers, (User)LoginManager.getInstance().getUser());
        this.gui.setData(this.getAccountsToShow(this.currentDriver));
        this.display();
    }

    void gotReturned() {
        Delivery delivery = Delivery.getCurrentDelivery((User)this.currentDriver);
        if (this.deliveryHelper.doReturn(delivery, LoginManager.getInstance().getUser())) {
            this.gui.setData(this.getAccountsToShow(this.currentDriver));
            this.refreshButtons();
        }
    }

    void gotDelete(Account account) {
        Delivery delivery = Delivery.getCurrentDelivery((User)this.currentDriver);
        if (!this.deliveryHelper.obtainLock((Lockable)account, "Account", LoginManager.getInstance().getUser())) {
            return;
        }
        if (!this.deliveryHelper.obtainLock((Lockable)delivery, "Delivery", LoginManager.getInstance().getUser())) {
            return;
        }
        delivery.removeAccount(account);
        if (delivery.getAccounts().isEmpty()) {
            delivery.markAsDeleted();
        }
        ((PhoneAccount)account).setDelivery(null);
        delivery.save();
        delivery.unlock();
        account.save();
        account.unlock();
        this.gui.setData(this.getAccountsToShow(this.currentDriver));
        this.refreshButtons();
    }

    public void gotCompleted() {
        this.completedDeliveries.startCompletedDeliveries();
    }

    void gotButtonPressed() {
        if (!this.gui.getSelectedDriver().equals((Object)this.currentDriver)) {
            this.currentDriver = this.gui.getSelectedDriver();
            this.refreshButtons();
            this.gui.setData(this.getAccountsToShow(this.currentDriver));
        }
    }

    public void gotSettle() {
        this.returnedDeliveries.start(this.currentDriver, true);
    }

    public void gotBack() {
        this.screenStopped();
    }

    public void gotOk() {
        this.screenStopped();
    }

    void gotAccountSelected(Account selectedAccount) {
        if (this.currentDriver.getDriverTracking() != null) {
            Dialogs.displayOkDialog((String)"This account is assigned to a driver from a driver tracking integration. We cannot make changes to accounts that have already been assigned.", (String)("This account is already assigned to a " + this.currentDriver.getName() + "!"));
        } else {
            this.accountSelected.emit((Object)selectedAccount);
        }
    }

    public void gotPrint() {
        Delivery printAccount = Delivery.getCurrentDelivery((User)this.currentDriver);
        List billsToPrint = printAccount.getAccounts();
        for (Account currentAccount : billsToPrint) {
            if (WaitermateSaveAccount.getInstance().lockAccount((Lockable)currentAccount)) {
                WaitermateSaveAccount.getInstance().printReceiptDockets((ItemGroup)currentAccount);
                currentAccount.unlock();
            } else {
                Dialogs.displayOkDialog((String)("<html>Account for " + currentAccount.getCustomer().getName() + " could not be locked,<br> and therefore will not be printed</html>"), (String)"Cannot lock");
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                WaiterMate.LOG.error("Print thread sleep interrupted", (Throwable)e);
            }
        }
    }

    @Override
    public void start(Signal<Account, ?, ?, ?, ?> accSelectedSignal, Signal<?, ?, ?, ?, ?> backSignal) {
        this.accountSelected = accSelectedSignal;
        this.screenStopped = backSignal;
        this.display();
    }

    public void setAccountSelectedSignal(Signal<Account, ?, ?, ?, ?> accSelectedSignal) {
        this.accountSelected = accSelectedSignal;
    }

    public void setUp() {
        this.show();
    }

    public void show() {
        this.currentDriver = this.gui.getSelectedDriver();
        this.setupDriversScreen();
        this.refreshButtons();
    }

    public void setupDriversScreen() {
        User user = LoginManager.getInstance().getUser();
        List drivers = User.getClockedOnDrivers();
        List integrators = DriverTrackingConfig.getActiveDriverTrackingUsers();
        ArrayList allUsers = new ArrayList(drivers.size() + integrators.size());
        allUsers.addAll(drivers);
        allUsers.addAll(integrators);
        this.gui.setDrivers(allUsers);
        User selectedDriver = null;
        boolean noPermission = false;
        if (this.gui.hasDrivers()) {
            if (user.hasPermission(AllPermissions.ASSIGN_DELIVERY_TO_OTHERS)) {
                selectedDriver = this.gui.getSelectedDriver();
                if (selectedDriver == null || !selectedDriver.isClockedOn()) {
                    selectedDriver = user.isDriver() && this.gui.hasDriver(user) ? user : this.gui.getFirstDriverInt();
                }
            } else if (user.hasPermission(AllPermissions.ASSIGN_DELIVERY) && user.isDriver() && user.isClockedOn()) {
                selectedDriver = user;
            } else {
                noPermission = true;
                selectedDriver = null;
            }
        }
        this.gui.setSelectedDriver(selectedDriver);
        this.currentDriver = selectedDriver;
        List accountsToShow = this.getAccountsToShow(selectedDriver);
        if (noPermission) {
            this.gui.setDeliveryInfo("You are not clocked on or do not have permission to assign deliveries");
        }
        if (accountsToShow != null) {
            this.gui.setData(accountsToShow);
        }
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void tearDown() {
    }

    public JComponent nav() {
        return this.nav;
    }

    public List getAccountsToShow(User driver) {
        if (driver == null) {
            this.gui.setDeliveryInfo("Select a driver to view their current delivery");
            return Collections.emptyList();
        }
        if (driver.getDriverTracking() != null) {
            List accountsToDisplay = PhoneAccount.getUndeliveredAccountsForDriver((User)driver);
            this.gui.setDeliveryInfo(accountsToDisplay.size() + " account(s) assigned to be delivered by a " + driver.getName());
            return accountsToDisplay;
        }
        Delivery currentDelivery = Delivery.getCurrentDelivery((User)driver);
        if (currentDelivery != null) {
            currentDelivery.save();
            String deliveryDetails = currentDelivery.getDeliveryDetails();
            this.gui.setDeliveryInfo(deliveryDetails);
        } else {
            this.gui.setDeliveryInfo("No delivery assigned to " + driver.getLabel());
        }
        return PhoneAccount.getAccountsForDriver((User)driver, (String)Delivery.DELIVERY_ASSIGNED);
    }

    public void refreshButtons() {
        if (this.currentDriver != null) {
            Delivery accountAssigned = Delivery.getCurrentDelivery((User)this.currentDriver);
            this.setAssignEnabled(true);
            this.setPrintButtonEnabled(accountAssigned != null);
            this.setReturnedEnabled(accountAssigned != null);
            this.setSettleDeliveriesEnabled(this.hasUnsettledDeliveries(this.currentDriver));
            if (this.currentDriver.getDriverTracking() != null) {
                this.setReturnedEnabled(false);
            }
        } else {
            this.setAssignEnabled(false);
            this.setReturnedEnabled(false);
            this.setSettleDeliveriesEnabled(false);
            this.setPrintButtonEnabled(false);
        }
    }

    private boolean hasUnsettledDeliveries(User driver) {
        return PhoneAccountQueries.getUserDeliveryAccountCount((User)driver) > 0L;
    }

    private void setAssignEnabled(boolean enable) {
        this.nav.setAssignEnabled(enable);
    }

    private void setReturnedEnabled(boolean enable) {
        this.nav.setReturnedEnabled(enable);
    }

    private void setPrintButtonEnabled(boolean enable) {
        this.nav.setPrintButtonEnabled(enable);
    }

    private void setSettleDeliveriesEnabled(boolean enable) {
        this.nav.setSettleDeliveriesEnabled(enable);
    }

    public void screenStopped() {
        this.screenStopped.emit();
    }

    protected void gotAccountID(Long accId) {
        if (this.isDisplaying() && this.currentDriver != null) {
            ObjectQuery qry = Query.select(PhoneAccount.class).equals(PhoneAccount.Properties.ID, (Object)accId).instanceOf(PhoneAccount.class);
            PhoneAccount acc = (PhoneAccount)PersistenceManager.getObject(PhoneAccount.class, (String)qry.toString(), null);
            this.gotCreateNewDelivery(Collections.singletonList(acc));
        }
    }

    protected void gotPrintDriverSummary() {
        OrderMate.LOG.info("Printing driver summary docket for " + this.currentDriver);
        Terminal thisTerminal = Terminal.getLocalHost();
        List printers = Terminal.getLocalHost().getAvailableReceiptPrinters();
        if (printers.isEmpty()) {
            Dialogs.displayOkDialog((String)"No receipt printers for this terminal, cannot print driver summary", (String)"Could not print driver summary");
            return;
        }
        try {
            DocketProcessor.printDriverySummaryDocket((User)this.currentDriver, (TradingDay)thisTerminal.getShift().getTradingDay(), (TradingDay)thisTerminal.getShift().getTradingDay(), (List)printers, (EventContext)LoginManager.getEventContext());
        }
        catch (IOException e) {
            WaiterMate.LOG.error("Couldn't print driver summary docket", (Throwable)e);
            Dialogs.displayOkDialog((String)"An error has occurred when attempting to print the driver summary docket", (String)"Could not print driver summary docket");
        }
    }

    protected void gotAutoAssign() {
        AutoAssignDriverSelector.getInstance().reset();
        AutoAssignDriverSelector.getInstance().setAutoAssign();
        this.show();
    }
}

