/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone.drivers;

import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.glazedlists.SequentialComparator;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.PhoneAccount;
import ordermate.gui.DisplayableObjectWrapper;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.selectaccount.phone.PhoneAccountRenderer;
import waitermate.gui.screens.selectaccount.phone.drivers.AccountSelectionPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.components.DrawerToggleButton;
import waitermate.guikit.components.SelectableToggleDrawerPanel;
import waitermate.guikit.dialogs.Dialogs;

public class UnassignedOrdersScreen
extends AbstractScreen {
    public final Signal createNewDelivery = Signals.createSignal(List.class, (String)"selectedAccounts");
    public final Signal cancel = Signals.createSignal();
    private AccountSelectionPanel<Account> mainPanel;
    private NavBar navBar;
    private SelectableToggleDrawerPanel sortDrawer;

    public UnassignedOrdersScreen() {
        this.mainPanel = new AccountSelectionPanel(new PhoneAccountRenderer(), (Comparator)new PropertyComparator(Account.Properties.CREATION_DATE_TIME));
        this.navBar = new NavBar();
        this.navBar.ok.connect((Object)this, "gotCreateDelivery");
        this.navBar.cancel.connect(this.cancel);
        this.navBar.setText("Select Accounts to add to this Delivery");
        this.navBar.addRight((Component)this.navBar.getOkButton());
        this.navBar.addLeft((Component)this.navBar.getCancelButton());
        DrawerToggleButton sortButton = this.navBar.constructDrawerToggleButton("Sort", IconLoader.get((String)"/waitermate/images/atoz.png"), IconLoader.get((String)"/waitermate/images/atoz.png"));
        ArrayList<DisplayableObjectWrapper> properties = new ArrayList<DisplayableObjectWrapper>();
        properties.add(new DisplayableObjectWrapper((Object)Account.Properties.CREATION_DATE_TIME, "Time Created"));
        properties.add(new DisplayableObjectWrapper((Object)PhoneAccount.Properties.TIME_DUE, "Time Due"));
        properties.add(new DisplayableObjectWrapper((Object)Customer.Properties.SUBURB, "Suburb"));
        this.sortDrawer = new SelectableToggleDrawerPanel(properties, DisplayableObjectWrapper.class, true);
        this.sortDrawer.changed.connect((Object)this, "sortBy");
        sortButton.setDrawer((JComponent)this.sortDrawer);
        this.navBar.addLeft((Component)sortButton);
    }

    public void start() {
        List phoneAccounts = PhoneAccount.getUnassignedDeliveryAccounts();
        if (phoneAccounts == null || phoneAccounts.size() == 0) {
            Dialogs.displayOkDialog((String)"<html>There are no unnassigned accounts.</html>", (String)"No Accounts");
            this.navBar.back.emit();
        } else {
            this.mainPanel.setAccounts(phoneAccounts);
            this.display();
        }
    }

    public JComponent getMainArea() {
        return this.mainPanel;
    }

    public NavBar getNavBar() {
        return this.navBar;
    }

    void gotCancel() {
        this.mainPanel.dropAccounts();
        this.cancel.emit();
    }

    void gotCreateDelivery() {
        ArrayList<Account> selectedAccountsList = new ArrayList<Account>(this.mainPanel.getSelectedAccounts());
        this.mainPanel.dropAccounts();
        this.createNewDelivery.emit(selectedAccountsList);
    }

    void sortBy() {
        List properties = this.sortDrawer.getSelectedObjects();
        PropertiedObject.Property property = properties == null || properties.size() == 0 ? Account.Properties.CREATION_DATE_TIME : (PropertiedObject.Property)((DisplayableObjectWrapper)properties.get(0)).getWrappedObject();
        PropertyComparator baseComparator = new PropertyComparator(Account.Properties.CREATION_DATE_TIME);
        if (property == Account.Properties.CREATION_DATE_TIME) {
            this.mainPanel.setSortAccounts((Comparator<Account>)baseComparator);
        } else if (property == PhoneAccount.Properties.TIME_DUE) {
            SequentialComparator comparator = new SequentialComparator();
            comparator.addComparator((Comparator)new PropertyComparator(property));
            comparator.addComparator((Comparator)baseComparator);
            this.mainPanel.setSortAccounts((Comparator<Account>)comparator);
        } else if (property == Customer.Properties.SUBURB) {
            SequentialComparator comparator = new SequentialComparator();
            ArrayList<PropertiedObject.Property> links = new ArrayList<PropertiedObject.Property>();
            links.add(Account.Properties.CUSTOMER);
            comparator.addComparator((Comparator)new PropertyComparator(links, property));
            this.mainPanel.setSortAccounts((Comparator<Account>)comparator);
        }
    }
}

