/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone.settle;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlBuilder;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.Customer;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.PhoneAccount;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class DeliveredAccountPanel
extends JPanel {
    private PhoneAccount account;
    private JLabel itemLabel;
    private JLabel priceLabel;
    private JLabel deliveryLabel;
    private JCheckBox selectedCheck;
    public final Signal<PhoneAccount, Boolean, ?, ?, ?> accountSelected = Signals.createSignal(PhoneAccount.class, (String)"account", Boolean.class, (String)"selected");

    public DeliveredAccountPanel() {
        this.setLayout((LayoutManager)new GraphPaperLayout(25, 1));
        this.initSelectedCheck();
        this.deliveryLabel = new JLabel();
        this.itemLabel = new JLabel();
        this.priceLabel = new JLabel();
        this.priceLabel.setHorizontalAlignment(0);
        this.priceLabel.setHorizontalTextPosition(2);
        this.add((Component)this.selectedCheck, new Rectangle(0, 0, 3, 1));
        this.add((Component)this.deliveryLabel, new Rectangle(3, 0, 3, 1));
        this.add((Component)this.itemLabel, new Rectangle(6, 0, 13, 1));
        this.add((Component)this.priceLabel, new Rectangle(20, 0, 4, 1));
    }

    private void initSelectedCheck() {
        this.selectedCheck = new JCheckBox();
        OrderMateTheme.setupTransparentButton((AbstractButton)this.selectedCheck);
        this.selectedCheck.setIcon(IconLoader.get((String)"/waitermate/images/cancel32.png"));
        this.selectedCheck.setSelectedIcon(IconLoader.get((String)"/waitermate/images/ok32.png"));
        this.selectedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliveredAccountPanel.this.accountSelected.emit((Object)DeliveredAccountPanel.this.account, (Object)DeliveredAccountPanel.this.selectedCheck.isSelected());
            }
        });
    }

    public PhoneAccount getAccount() {
        return this.account;
    }

    public void setAccount(PhoneAccount anAccount, boolean selected) {
        this.account = anAccount;
        if (this.account == null) {
            this.deliveryLabel.setText("");
            this.itemLabel.setText("");
            this.priceLabel.setText("");
            return;
        }
        this.updateSelectedCheck(selected);
        this.deliveryLabel.setText("<html><b><font color=\"#ff0000\">" + DateTimeUtils.getSimpleTimeFormat().format(this.account.getCreationDateTime()) + "</font></b></h3><html>");
        this.deliveryLabel.setForeground(this.account.getBackgroundColor());
        this.itemLabel.setText(this.getDeliveryItemText(this.account));
        this.priceLabel.setText(this.account.getTotal().toString());
        this.priceLabel.setBackground(this.account.getBackgroundColor());
        this.priceLabel.setOpaque(true);
        if (this.account.isPaidWithMoney()) {
            FinanceTransaction tran = (FinanceTransaction)this.account.getFinanceTransactions().get(0);
            this.priceLabel.setIcon(IconLoader.get((String)tran.getIcon()));
        } else {
            this.priceLabel.setIcon(null);
        }
    }

    private String getDeliveryItemText(PhoneAccount account) {
        Customer customer = account.getCustomer();
        HtmlBuilder builder = new HtmlBuilder().append(customer.getName()).append("- ").append(customer.getSuburb()).append(" (").append(customer.getPrimaryPhoneNumber()).append(")");
        if (account.getDelivery() != null && !StringUtils.isEmpty((String)account.getDelivery().getExtDriverName())) {
            builder.appendLineBreak().appendColor("(Driver: " + account.getDelivery().getExtDriverName() + ")", "green");
        }
        return builder.toString();
    }

    private void updateSelectedCheck(boolean selected) {
        this.selectedCheck.setSelected(selected);
        this.selectedCheck.setName(this.account.getID() + "selectedCheck");
        Delivery delivery = this.account.getDelivery();
        if (delivery == null || delivery.getDriver() == null || delivery.getDriver().getDriverTracking() == null) {
            this.selectedCheck.setEnabled(false);
        } else {
            this.selectedCheck.setEnabled(true);
        }
    }
}

