/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone.settle;

import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.sales.PhoneAccount;
import ordermate.gui.scroll.Renderer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.selectaccount.phone.settle.DeliveredAccountPanel;

public class DeliveredAccountsRenderer
implements Renderer {
    public final Signal<PhoneAccount, Boolean, ?, ?, ?> accountSelected = Signals.createSignal(PhoneAccount.class, (String)"account", Boolean.class, (String)"selected");
    private Set<Component> components = new HashSet<Component>();
    private Set<PhoneAccount> selectedAccounts = new HashSet<PhoneAccount>();

    public Component createComponent() {
        return new DeliveredAccountPanel();
    }

    public void setupComponent(Component component, Object object, int index) {
        DeliveredAccountPanel panel = (DeliveredAccountPanel)component;
        PhoneAccount account = (PhoneAccount)object;
        boolean selected = this.selectedAccounts.contains(account);
        panel.setAccount(account, selected);
        if (!this.components.contains(component)) {
            panel.accountSelected.connect((Object)this, "gotAccountSelected");
            this.components.add(component);
        }
    }

    public void gotAccountSelected(PhoneAccount account, Boolean selected) {
        if (selected.booleanValue()) {
            if (this.selectedAccounts.contains(account)) {
                OrderMate.LOG.warn("Severe issue in DeliveredAccountsRenderer! The" + account + " shouldn't be already in selected accounts list!");
                return;
            }
            this.selectedAccounts.add(account);
        } else {
            if (!this.selectedAccounts.contains(account)) {
                OrderMate.LOG.warn("Severe issue in DeliveredAccountsRenderer! The" + account + " should be in selected accounts list to be removed!");
                return;
            }
            this.selectedAccounts.remove(account);
        }
        this.accountSelected.emit((Object)account, (Object)selected);
    }

    void cleanUp() {
        this.selectedAccounts.clear();
    }

    public Set<PhoneAccount> getSelectedAccounts() {
        return Collections.unmodifiableSet(this.selectedAccounts);
    }

    void setSelectedAccounts(List<PhoneAccount> accounts) {
        this.selectedAccounts = new HashSet<PhoneAccount>(accounts);
    }
}

