/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.phone.settle;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.ButtonInfo;
import ordermate.database.Lockable;
import ordermate.database.Payable;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.users.User;
import ordermate.services.hardware.physical.eftpos.CashDrawerManager;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.dialogs.UnlockDialog;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.selectaccount.phone.drivers.AutoAssignDriverSelector;
import waitermate.gui.screens.selectaccount.phone.settle.SettleDeliveryAccountsGui;
import waitermate.gui.screens.selectaccount.phone.settle.SettleDeliveryAccountsNav;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class SettleDeliveryAccounts
extends AbstractScreen {
    public final Signal accountSelected = Signals.createSignal(ButtonInfo.class, (String)"Selected Account");
    public final Signal stopped = Signals.createSignal();
    private SettleDeliveryAccountsGui gui = new SettleDeliveryAccountsGui();
    private SettleDeliveryAccountsNav nav = new SettleDeliveryAccountsNav();
    private UnlockDialog unlockDialog;
    private User driver;
    private List<Delivery> deliveries;

    public SettleDeliveryAccounts() {
        this.nav.back.connect((Object)this, "gotStopped");
        this.nav.pay.connect((Object)this, "gotPay");
        this.unlockDialog = new UnlockDialog();
    }

    public void start(User theDriver, boolean fullScreen) {
        this.driver = theDriver;
        this.display(fullScreen);
    }

    public void setUp() {
        HashSet allAccounts = new HashSet();
        ArrayList<PhoneAccount> accounts = new ArrayList<PhoneAccount>();
        this.deliveries = Delivery.getReturnedDeliveries((User)this.driver);
        for (Delivery delivery : this.deliveries) {
            allAccounts.addAll(delivery.getAccounts());
        }
        for (PhoneAccount account : allAccounts) {
            if (!account.isDelivered()) continue;
            accounts.add(account);
        }
        Collections.sort(accounts, new Comparator<PhoneAccount>(){

            @Override
            public int compare(PhoneAccount a1, PhoneAccount a2) {
                return a1.getCreationDateTime().compareTo(a2.getCreationDateTime());
            }
        });
        this.gui.displayAccounts(accounts, this.driver);
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotPay() {
        for (PhoneAccount account : this.gui.getSelectedAccounts()) {
            if (account.getDelivery() == null) continue;
            this.payDelivery(account.getDelivery(), LoginManager.getInstance().getUser());
        }
        if (!this.gui.getSelectedAccounts().isEmpty()) {
            CashDrawerManager.getInstance().openAllCashDrawersSettleDelivery(LoginManager.getInstance().getUser(), Terminal.getLocalHost());
        }
        this.clockOffDriver();
        this.gotStopped();
    }

    private void clockOffDriver() {
        if (this.driver.getDriverTracking() == null && this.driver.isClockedOn() && Delivery.getCurrentDelivery((User)this.driver) == null && Dialogs.displayChoiceDialog((String)("Do you want to clock off user " + this.driver.getName()), (String)"Clock Off?", null, (String)"No", (boolean)true)) {
            this.driver.clockOff();
        }
    }

    private void payDelivery(Delivery delivery, User user) {
        if (!delivery.lock(user) && !this.unlockDialog.display((Lockable)delivery, "Delivery")) {
            return;
        }
        if (!this.doCheckAccountTradingDays(delivery)) {
            delivery.unlock();
            return;
        }
        List toSettle = delivery.getAccounts();
        boolean canClose = true;
        Iterator iterator = toSettle.iterator();
        while (iterator.hasNext()) {
            PhoneAccount nextAccount;
            PhoneAccount account = nextAccount = (PhoneAccount)iterator.next();
            if ((account = (PhoneAccount)PersistenceManager.reacquire((PersistentObjectI)account)).isLocked(user) || account.lock(user)) {
                if (account.isDelivered() && account.isOpen() && (account.getPaidState().equals(Payable.NOT_PAID) || account.getPaidState().equals(Payable.CREDIT))) {
                    CashTransaction transaction = new CashTransaction(account.getUser(), Terminal.getLocalHost(), account.getDue(), account.getDue(), new Price(0.0), Terminal.getLocalHost().getAssignedCashDrawer(user), Terminal.getLocalHost().getShift());
                    account.addFinanceTransaction((FinanceTransaction)transaction);
                }
                WaitermateSaveAccount.getInstance().closeAccount((Account)account, true, false, LoginManager.getEventContext());
                account.unlock();
            }
            if (!account.isOpen()) continue;
            canClose = false;
        }
        if (canClose) {
            delivery.markAsPaid();
            PersistenceManager.save((PersistentObject)delivery);
        }
        delivery.unlock();
    }

    private boolean doCheckAccountTradingDays(Delivery delivery) {
        Iterator it = delivery.getAccounts().iterator();
        Shift terminalShift = Terminal.getLocalHost().getShift();
        boolean okToSettle = true;
        boolean hasUserBeenPrompted = false;
        while (it.hasNext()) {
            PhoneAccount account = (PhoneAccount)it.next();
            if (terminalShift.equals((Object)account.getShift())) continue;
            String s = "<html>Settling this delivery may cause discrepancies <br>between the Sales Report and My Tills.<br><br>An account in this delivery was created on " + account.getShift() + "<br>however it is currently " + terminalShift + "<br><br>Do you want to continue?";
            if (!hasUserBeenPrompted) {
                okToSettle = Dialogs.displayChoiceDialog((String)s, (String)"Stale account", (boolean)true);
                hasUserBeenPrompted = true;
            }
            if (!okToSettle) break;
            TerminalEventLog.logTradingDayDiscrepancy((User)LoginManager.getInstance().getUser(), (Terminal)Terminal.getLocalHost(), (String)("Account " + account.getLabel() + " was created on " + account.getShift() + " but settled on " + terminalShift));
        }
        return okToSettle;
    }

    void gotStopped() {
        AutoAssignDriverSelector.getInstance().checkAutoAssignedUser(this.driver);
        this.tearDown();
        this.gui.cleanUp();
        this.stopped.emit();
    }
}

