/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.quicksale;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.sales.Account;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import waitermate.guikit.dialogs.PopupWindow;

class ConfirmFinanceUnit {
    private DecimalFormat format = new DecimalFormat("0.0##%");
    private final Account theAccount;
    private final List<FinanceUnit> units;
    private boolean surcharged = true;

    ConfirmFinanceUnit(Account currentAccount, List<FinanceUnit> availableUnits) {
        this.theAccount = currentAccount;
        this.units = availableUnits;
    }

    FinanceUnit confirmUnit(FinanceUnit currentUnit) {
        FinanceUnit toReturn = currentUnit != null ? currentUnit : this.units.get(0);
        ExperimentalFeature exp = ExperimentalFeature.find((String)"Skip Quick Eftpos Prompt");
        if (exp != null && exp.getBooleanValue(Boolean.FALSE).booleanValue()) {
            return toReturn;
        }
        if (currentUnit == null) {
            double surcharge = toReturn.getSurcharge();
            boolean surchargeDifferent = false;
            for (FinanceUnit unit : this.units) {
                if (!(Math.abs(surcharge - unit.getSurcharge()) > 1.0E-5)) continue;
                surchargeDifferent = true;
                break;
            }
            if (surchargeDifferent) {
                toReturn = this.showChooseDialog();
            }
        } else if (currentUnit.getSurcharge() > 1.0E-4) {
            toReturn = this.showConfirmDialog(currentUnit);
        }
        return toReturn;
    }

    private FinanceUnit showChooseDialog() {
        SelectUnitPanel panel = new SelectUnitPanel();
        if (panel.startFillTheFrame()) {
            return panel.getSelectedUnit();
        }
        return null;
    }

    private FinanceUnit showConfirmDialog(FinanceUnit currentUnit) {
        ConfirmUnitPanel panel = new ConfirmUnitPanel(currentUnit);
        if (panel.start()) {
            return currentUnit;
        }
        return null;
    }

    public boolean isSurcharged() {
        return this.surcharged;
    }

    class SelectUnitPanel
    extends PopupWindow
    implements Renderer,
    ActionListener {
        private JCheckBox surchargeCheck;
        private CustomScrollPane scrolly;
        private JPanel holder;
        private JLabel amountDueLabel;
        private FinanceUnit unit = null;
        RendererScrollPaneModel<FinanceUnit> model;

        public SelectUnitPanel() {
            this.setupComponents();
            this.getNavBar().removeRight((Component)this.getNavBar().getOkButton());
            this.getNavBar().getCancelButton().setText("Cancel");
            this.getNavBar().setText("Please select the payment type");
        }

        private void setupComponents() {
            this.holder = new JPanel(new BorderLayout());
            JPanel northPanel = new JPanel(new GridLayout(2, 3));
            this.amountDueLabel = new JLabel("<html><h1>Amount Due: " + ConfirmFinanceUnit.this.theAccount.getDue() + "</h1></html>");
            this.amountDueLabel.setName("amountDue");
            northPanel.add((Component)this.amountDueLabel, "North");
            this.surchargeCheck = new JCheckBox("Apply Surcharge");
            this.surchargeCheck.setSelected(true);
            this.surchargeCheck.setName("surchargeCheck");
            this.surchargeCheck.addActionListener(this);
            this.surchargeCheck.setRolloverEnabled(false);
            this.surchargeCheck.setIcon(IconLoader.get((String)"/waitermate/images/cancel32.png"));
            this.surchargeCheck.setSelectedIcon(IconLoader.get((String)"/waitermate/images/ok32.png"));
            StandardSecurityDecorator decorator = new StandardSecurityDecorator((JComponent)this.surchargeCheck, AllPermissions.REMOVE_PAYMENT_SURCHARGE);
            northPanel.add((Component)decorator, "Center");
            this.holder.add((Component)northPanel, "North");
            this.model = new RendererScrollPaneModel((Renderer)this, 2, 5);
            this.model.addObjects((Collection)ConfirmFinanceUnit.this.units);
            this.scrolly = new CustomScrollPane(this.model);
            this.holder.add((Component)this.scrolly, "Center");
            this.setComponent(this.holder);
        }

        public Component createComponent() {
            return new FinanceUnitRenderer();
        }

        public void setupComponent(Component component, Object object, int index) {
            ((FinanceUnitRenderer)component).setUnit((FinanceUnit)object);
        }

        void gotUnit(FinanceUnit newUnit) {
            this.unit = newUnit;
            this.gotOk();
        }

        FinanceUnit getSelectedUnit() {
            return this.unit;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.surchargeCheck) {
                ConfirmFinanceUnit.this.surcharged = this.surchargeCheck.isSelected();
                this.scrolly.setModel(this.model);
            }
        }

        class FinanceUnitRenderer
        extends JPanel
        implements ActionListener {
            private FinanceUnit unit;
            private JButton button;
            private JLabel detailsLabel;

            FinanceUnitRenderer() {
                super(new GridLayout(1, 2));
                this.button = new JButton();
                this.button.addActionListener(this);
                this.detailsLabel = new JLabel();
            }

            void setUnit(FinanceUnit object) {
                this.unit = object;
                this.button.setIcon(IconLoader.get((String)this.determineIcon()));
                this.button.setText(object.getLabel());
                this.button.setHorizontalTextPosition(0);
                this.button.setVerticalTextPosition(3);
                this.detailsLabel.setText(this.determineDetails());
                this.add((Component)this.button, "West");
                this.add((Component)this.detailsLabel, "Center");
            }

            private String determineIcon() {
                String toReturn = "/waitermate/images/dcard.png";
                if (FinanceUnit.CREDIT_TYPE.toString().equals(this.unit.getType())) {
                    toReturn = "Visa".equalsIgnoreCase(this.unit.getLabel()) ? "/waitermate/images/cardvisa.png" : ("Mastercard".equalsIgnoreCase(this.unit.getLabel()) ? "/waitermate/images/cardmastercard.png" : ("Amex".equalsIgnoreCase(this.unit.getLabel()) ? "/waitermate/images/cardamex.png" : ("Diners".equalsIgnoreCase(this.unit.getLabel()) ? "/waitermate/images/carddiners.png" : "/waitermate/images/card.png")));
                }
                return toReturn;
            }

            private String determineDetails() {
                Price due = ConfirmFinanceUnit.this.theAccount.getDue();
                StringBuilder SB = new StringBuilder("<html>");
                if (SelectUnitPanel.this.surchargeCheck.isSelected()) {
                    Price surcharge = FinanceSurchargeCalculator.calculateSurcharge((Price)due, (Price)Price.ZERO_DOLLAR, (FinanceUnit)this.unit);
                    if (Price.ZERO_DOLLAR.approximatelyEquals(surcharge)) {
                        SB.append("<br><font color='gray'>");
                    } else {
                        SB.append("<br>");
                    }
                    SB.append("Surcharge (").append(ConfirmFinanceUnit.this.format.format(this.unit.getSurcharge())).append("): ").append(surcharge).append("</font>");
                    SB.append("<br><h2>Total: ").append(due.add(surcharge)).append("</h2>");
                } else {
                    SB.append("<h2>Total: ").append(due).append("</h2>");
                }
                SB.append("</html>");
                return SB.toString();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectUnitPanel.this.gotUnit(this.unit);
            }
        }
    }

    class ConfirmUnitPanel
    extends PopupWindow
    implements ActionListener {
        private JCheckBox surchargeCheck;
        private JLabel amountDueLabel;
        private JLabel totalLabel;
        private final FinanceUnit unit;

        public ConfirmUnitPanel(FinanceUnit unit) {
            this.unit = unit;
            this.amountDueLabel = new JLabel();
            this.totalLabel = new JLabel();
            this.surchargeCheck = new JCheckBox("Apply Surcharge");
            this.surchargeCheck.setSelected(true);
            this.surchargeCheck.setName("surchargeCheck");
            this.surchargeCheck.addActionListener(this);
            this.surchargeCheck.setRolloverEnabled(false);
            this.surchargeCheck.setIcon(IconLoader.get((String)"/waitermate/images/cancel32.png"));
            this.surchargeCheck.setSelectedIcon(IconLoader.get((String)"/waitermate/images/ok32.png"));
            StandardSecurityDecorator decorator = new StandardSecurityDecorator((JComponent)this.surchargeCheck, AllPermissions.REMOVE_PAYMENT_SURCHARGE);
            JPanel holder = new JPanel();
            holder.setLayout(new GridLayout(4, 1));
            holder.add(new JLabel("This payment incurs a surcharge, do you wish to proceed?"));
            holder.add(this.amountDueLabel);
            holder.add((Component)decorator);
            holder.add(this.totalLabel);
            this.surchargeCheck.addActionListener(this);
            this.setComponent(holder);
            this.update();
        }

        private void update() {
            Price due = ConfirmFinanceUnit.this.theAccount.getDue();
            Price surcharge = FinanceSurchargeCalculator.calculateSurcharge((Price)due, (Price)Price.ZERO_DOLLAR, (FinanceUnit)this.unit);
            this.amountDueLabel.setText("Amount Due: " + due.toString());
            if (this.surchargeCheck.isSelected()) {
                this.surchargeCheck.setText("Surcharge: " + surcharge.toString());
                this.totalLabel.setText("<html><h2>Total: " + due.add(surcharge).toString() + "</h2></html>");
            } else {
                this.surchargeCheck.setText("Surcharge: " + Price.ZERO_DOLLAR.toString());
                this.totalLabel.setText("<html><h2>Total: " + due + "</h2></html>");
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.surchargeCheck) {
                ConfirmFinanceUnit.this.surcharged = this.surchargeCheck.isSelected();
                this.update();
            }
        }
    }
}

