/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.quicksale;

import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.searchers.sales.AccountResultsSorter;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.database.searchers.sales.AccountSearcherWithDebtorPayments;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.closedaccounts.closedaccountslist.ClosedAccountRenderer;

public class PreviousSalesListPanel
extends JPanel {
    private static final int DEFAULT_LIMIT = 12;
    public final Signal accountSelected = Signals.createSignal(Account.class, (String)"account");
    private final CustomScrollPane scroll;
    private final ClosedAccountRenderer renderer;
    private final RendererScrollPaneModel<Account> scrollModel;
    private final AccountSearcher searcher;
    private final AccountSearcherWithDebtorPayments searcherDebtorPayments;

    public PreviousSalesListPanel(List<AccountType> types, List<Terminal> terminals) {
        this.searcher = new AccountSearcher(12, FinanceTransaction.Properties.CREATION_TIME, false);
        this.searcher.disableOptimisation();
        this.searcherDebtorPayments = new AccountSearcherWithDebtorPayments(12, DebtorSale.Properties.SALE_DATE, false);
        if (terminals != null && !terminals.isEmpty()) {
            this.searcher.getTerminalSearch().setSearchValue(terminals);
            this.searcherDebtorPayments.getTerminalSearch().setSearchValue(terminals);
        }
        if (types != null && !types.isEmpty()) {
            this.searcher.getAccountTypeListSearch().setSearchOptions(types);
            this.searcherDebtorPayments.getAccountTypeListSearch().setSearchOptions(types);
        }
        this.renderer = new ClosedAccountRenderer();
        this.scrollModel = new RendererScrollPaneModel((Renderer)this.renderer, 1, 6);
        this.scroll = new CustomScrollPane(this.scrollModel);
        this.setupComponents();
        this.renderer.selected.connect((Object)this, "gotAccount");
    }

    private void setupComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroll, "Center");
        this.scroll.setMinimumSize(new Dimension(300, 400));
        this.scroll.setPreferredSize(this.scroll.getMinimumSize());
        JLabel headerLabel = new JLabel(Internationalization.getLiteralFor((String)"PREVIOUS_ACCOUNTS") + ":");
        headerLabel.setFont(OrderMateTheme.getMediumFont());
        this.add((Component)headerLabel, "North");
    }

    public void updateList(boolean isShowing) {
        Calendar oneWeekAgo = Calendar.getInstance();
        oneWeekAgo.add(5, -7);
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.add(5, 1);
        this.searcher.getDateRangeSearch().setStart((Comparable)oneWeekAgo.getTime());
        this.searcher.getDateRangeSearch().setEnd((Comparable)tomorrow.getTime());
        this.searcher.getPayOffDayFilter().setSearchValue((Object)TradingDay.getCurrentTradingDay());
        this.searcherDebtorPayments.getDateRangeSearch().setStart((Comparable)oneWeekAgo.getTime());
        this.searcherDebtorPayments.getDateRangeSearch().setEnd((Comparable)tomorrow.getTime());
        this.searcherDebtorPayments.getPayOffDayFilter().setStart((Comparable)oneWeekAgo.getTime());
        this.searcherDebtorPayments.getPayOffDayFilter().setEnd((Comparable)tomorrow.getTime());
        this.renderer.reset();
        List results = AccountResultsSorter.combineLists((List)PersistenceManager.getObjectList((ObjectQuerySearcher)this.searcher), (List)PersistenceManager.getObjectList((ObjectQuerySearcher)this.searcherDebtorPayments));
        Iterator accountIterator = results.iterator();
        while (accountIterator.hasNext()) {
            Account account = (Account)accountIterator.next();
            if (!account.getDue().greaterThan((Object)Price.ZERO_NO_ROUND)) continue;
            accountIterator.remove();
        }
        if (isShowing) {
            this.scrollModel.setObjects(results);
        }
    }

    public void gotAccount(Account account) {
        this.accountSelected.emit((Object)account);
    }
}

