/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table;

import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.integration.RDConfiguration;
import ordermate.database.misc.SystemProperty;
import ordermate.database.tables.LogicalTableState;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.integration.restaurantdiary.RDContext;
import ordermate.integration.restaurantdiary.RDContextGrabber;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.selectaccount.AccountNavBar;
import waitermate.gui.tablelayout.tablestate.TableStatePanel;
import waitermate.guikit.components.DrawerToggleButton;

public class TableAccountSelectionNav
extends AccountNavBar {
    private StandardSecurityDecorator reservationsButton;
    private StandardSecurityDecorator moveTablesButton;
    private StandardSecurityDecorator moveTabsButton;
    private StandardSecurityDecorator tableStateDecorator;
    private DrawerToggleButton tableStateButton;
    public final Signal reservations = Signals.createSignal();
    public final Signal moveTables = Signals.createSignal();
    public final Signal moveTabs = Signals.createSignal();
    public final Signal<LogicalTableState, ?, ?, ?, ?> tableState = Signals.createSignal(LogicalTableState.class, (String)"theState");

    public TableAccountSelectionNav(boolean isUnallocatedTables) {
        super("Unallocated Order", "/waitermate/images/icon_createtable48.png");
        ExperimentalFeature expFeature;
        if (isUnallocatedTables && ((expFeature = ExperimentalFeature.find((String)"Create Unallocated Enabled")) == null || expFeature.getBooleanValue(Boolean.TRUE).booleanValue())) {
            this.addRight(this.getCreateNew());
        }
    }

    @Override
    protected void setupComponents() {
        JButton button = this.constructButton(IconLoader.get((String)"/waitermate/images/reservations.png"), "<html>Reservations</html>", "reservations");
        this.reservationsButton = new StandardSecurityDecorator((JComponent)button, AllPermissions.RESERVATIONS);
        this.addRight((Component)this.reservationsButton);
        this.reservationsButton.setVisible(SystemProperty.getInstance().isReservationsEnabled());
        JButton moveTableJButton = this.constructButton(IconLoader.get((String)"/waitermate/images/gtlMove.png"), "Rearrange Tables", "moveTableMode");
        this.moveTablesButton = new StandardSecurityDecorator((JComponent)moveTableJButton, AllPermissions.MOVE_TABLE);
        JButton moveTabsJButton = this.constructButton(IconLoader.get((String)"/waitermate/images/move_tabs.png"), "Move Tabs", "moveTabs");
        this.moveTabsButton = new StandardSecurityDecorator((JComponent)moveTabsJButton, AllPermissions.MOVE_TABS);
        this.addRight((Component)this.moveTablesButton);
        this.addRight((Component)this.moveTabsButton);
        this.tableStateButton = this.constructDrawerToggleButton("Table State", IconLoader.get((String)"/waitermate/images/table_states.png"), IconLoader.get((String)"/waitermate/images/table_states.png"));
        this.tableStateButton.setName("tableState");
        TableStatePanel panel = new TableStatePanel();
        panel.stateChanged.connect((Object)this, "gotTableStateChanged");
        this.tableStateButton.setDrawer((JComponent)panel);
        this.tableStateDecorator = new StandardSecurityDecorator((JComponent)this.tableStateButton, AllPermissions.ALTER_TABLE_STATE);
        this.addLeft((Component)this.tableStateDecorator);
        super.setupComponents();
        this.removeRight(this.getCreateNew());
    }

    public void setMoveTableButtonEnabled(boolean b) {
        this.moveTablesButton.setEnabled(b);
    }

    private void setReservationsVisible(boolean visible) {
        if (this.reservationsButton != null) {
            this.reservationsButton.setVisible(visible);
        }
    }

    private void setMoveButtonVisible(boolean visible) {
        if (this.moveTablesButton != null) {
            this.moveTablesButton.setVisible(visible);
        }
    }

    private void setTableStateVisible(boolean visible) {
        if (this.tableStateDecorator != null) {
            this.tableStateDecorator.setVisible(visible);
        }
    }

    private void setMoveTabsVisible(boolean visible) {
        if (this.moveTabsButton != null) {
            this.moveTabsButton.setVisible(visible);
        }
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Object source = e.getSource();
        if (source == this.reservationsButton.getDecorateComponent()) {
            this.reservations.emit();
        } else if (source == this.moveTablesButton.getDecorateComponent()) {
            this.moveTables.emit();
        } else if (source == this.moveTabsButton.getDecorateComponent()) {
            this.moveTabs.emit();
        }
    }

    public void setCustomButtonsVisible(boolean showButtons) {
        this.setReservationsVisible(showButtons);
        this.setQuickTransferVisible(showButtons);
        this.setMoveTabsVisible(showButtons);
        this.setTableStateVisible(showButtons);
    }

    public void gotTableStateChanged(LogicalTableState newState) {
        this.tableStateButton.closeDrawer();
        this.tableState.emit((Object)newState);
    }

    public void refresh() {
        if (RDConfiguration.checkConfigured()) {
            this.decorateReservationBtnForRD();
        }
    }

    private void decorateReservationBtnForRD() {
        Date syncDate;
        RDContext context = (RDContext)PersistenceManager.getServerConnection().runSync((Executable)new RDContextGrabber());
        Date date = syncDate = context != null ? context.getLastSyncDate() : null;
        if (syncDate != null) {
            long secs = DateTimeUtils.getDifferenceInMillisecs((Date)syncDate, (Date)new Date()) / 1000L;
            if (secs < 0L) {
                secs = 0L;
            }
            StringBuilder sb = new StringBuilder("Reservations<br> ");
            if (secs < 60L) {
                this.appendSyncText("(Synced " + secs + " secs ago)", sb);
            } else {
                long mins = secs / 60L % 60L;
                this.appendSyncText("(Synced " + mins + " mins ago)", sb);
            }
            ((JButton)this.reservationsButton.getDecorateComponent()).setText(HtmlUtils.htmlCenter((String)sb.toString()));
        }
    }

    private void appendSyncText(String syncMessage, StringBuilder sb) {
        sb.append(HtmlUtils.highlight((String)syncMessage, (String)"green", (boolean)false, (boolean)false, (int)2));
    }

    public void updateButtons() {
        this.setReservationsVisible(SystemProperty.getInstance().isReservationsEnabled());
    }
}

