/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table.allocate;

import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.Lockable;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.selectaccount.table.GraphicalTableSelectionPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class AllocateTableState
extends AbstractScreen {
    public final Signal<LogicalTable, Account, ?, ?, ?> accountAllocated = Signals.createSignal(LogicalTable.class, (String)"table", Account.class, (String)"account");
    public final Signal back = Signals.createSignal();
    private final GraphicalTableSelectionPanel selectionPanel;
    private final NavBar nav = new NavBar();
    private Account unallocatedAccount;

    public AllocateTableState() {
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.back.connect((Object)this, "gotBack");
        JButton noTable = this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/images/addCard.png"), "Order Without Table", "noTable");
        this.nav.addRight((Component)noTable);
        noTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AllocateTableState.this.gotTable(null);
            }
        });
        this.selectionPanel = new GraphicalTableSelectionPanel(false, Terminal.getLocalHost().getGtl());
        this.selectionPanel.tableSelected.connect((Object)this, "gotTable");
    }

    protected void gotTable(LogicalTable table) {
        if (table == null && this.unallocatedAccount != null) {
            this.accountAllocated.emit((Object)table, (Object)this.unallocatedAccount);
            return;
        }
        if (table != null && table.hasAccount()) {
            if (AccountType.tableType.equals((Object)this.unallocatedAccount.getAccountType())) {
                if (this.checkForDebtorPayment()) {
                    Dialogs.displayOkDialog((String)this.getDebtorPaymentMessage(), (String)"Unallocated Table has debtor payment");
                    return;
                }
                if (!Dialogs.displayChoiceDialog((String)this.getConfirmTransferMessage(table), (String)"Table has an account", (boolean)true)) {
                    return;
                }
                if (this.unallocatedAccount.hasPayments() && !Dialogs.displayChoiceDialog((String)this.getWarningFinanceTransactionMessage(), (String)"Unallocated account has payments", (boolean)true)) {
                    return;
                }
            } else if (AccountType.barTabType.equals((Object)this.unallocatedAccount.getAccountType()) && table.getBarTabs().isEmpty()) {
                Dialogs.displayOkDialog((String)"Table has a Table Account", (String)"You can only assign a BarTab to an empty table, or one with BarTabs already assigned.");
                return;
            }
        }
        if (this.unallocatedAccount != null) {
            this.accountAllocated.emit((Object)table, (Object)this.unallocatedAccount);
        }
    }

    private boolean checkForDebtorPayment() {
        for (FinanceTransaction txn : this.unallocatedAccount.getFinanceTransactions()) {
            if (txn.getMovedTransaction() == null) continue;
            return true;
        }
        return false;
    }

    private String getDebtorPaymentMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("You cannot allocate this account with debtor payment to a table that is occupied.").append(HtmlUtils.newline((int)1)).append("Please choose another table.");
        return HtmlUtils.html((String)sb.toString());
    }

    private String getConfirmTransferMessage(LogicalTable table) {
        StringBuilder tableMessage = new StringBuilder("Table ");
        tableMessage.append(table).append(" is already in use.").append(HtmlUtils.newline((int)1)).append(" If you continue, the unallocated items will be added to table ").append(table);
        return HtmlUtils.html((String)tableMessage.toString());
    }

    private String getWarningFinanceTransactionMessage() {
        StringBuilder warningMessage = new StringBuilder();
        warningMessage.append(HtmlUtils.boldColor((String)"Warning: ", (String)"RED")).append(" Account has transactions these will be permanently transferred to the selected account.").append(HtmlUtils.newline((int)1)).append("Are you sure you want to continue?");
        return HtmlUtils.html((String)warningMessage.toString());
    }

    protected void gotBack() {
        if (this.unallocatedAccount != null) {
            this.unallocatedAccount.unlock();
        }
        this.back.emit();
    }

    public void gotUnallocatedTableAccount(TableAccount account) {
        this.gotUnallocatedAccount((Account)account);
    }

    public void gotUnallocatedAccount(Account account) {
        block1: {
            this.display();
            if (account == null || !WaitermateSaveAccount.getInstance().lockAccount((Lockable)account)) {
                this.unallocatedAccount = null;
                this.nav.setText("Select account to allocate");
                return;
            }
            this.nav.setText("Select target table");
            this.display();
            this.unallocatedAccount = account;
            Iterator<TableGroup> iterator = this.selectionPanel.getTableGroups().iterator();
            if (!iterator.hasNext()) break block1;
            TableGroup group = iterator.next();
            this.selectionPanel.setCurrentTableGroup(group);
        }
    }

    public JComponent getMainArea() {
        return this.selectionPanel;
    }

    public NavBar getNavBar() {
        return this.nav;
    }
}

