/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table.allocate;

import java.util.List;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import waitermate.gui.screens.selectaccount.table.allocate.BarTabAllocator;
import waitermate.gui.screens.selectaccount.table.allocate.LogicalTableAllocator;
import waitermate.gui.screens.selectaccount.table.allocate.OpenTableAccountAllocator;
import waitermate.gui.screens.selectaccount.table.allocate.TableAccountAllocator;

public class LogicalTableAllocatorFactory {
    public static <T extends Account> LogicalTableAllocator<T> getAllocatorFor(T account, LogicalTable table) {
        AccountType type = account.getAccountType();
        if (AccountType.barTabType.equals((Object)type)) {
            return new BarTabAllocator();
        }
        if (account instanceof TableAccount) {
            if (LogicalTableAllocatorFactory.canMoveAccountToTableAsOpen((TableAccount)account, table)) {
                return new OpenTableAccountAllocator();
            }
            return new TableAccountAllocator();
        }
        throw new IllegalArgumentException("Cannot create allocator for unknown type:" + type);
    }

    private static boolean canMoveAccountToTableAsOpen(TableAccount account, LogicalTable table) {
        if (table == null || !table.hasAccount()) {
            return false;
        }
        List transactions = account.getFinanceTransactions();
        for (FinanceTransaction txn : transactions) {
            if (txn.getMovedTransaction() == null) continue;
            return false;
        }
        return true;
    }
}

