/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table.allocate;

import java.util.List;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.Account;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.users.User;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.selectaccount.table.allocate.TableAccountAllocator;
import waitermate.guikit.dialogs.Dialogs;

public class OpenTableAccountAllocator
extends TableAccountAllocator {
    @Override
    public Account allocateAccountToTable(LogicalTable table, TableAccount unallocatedTableAccount) {
        Account account = super.allocateAccountToTable(table, unallocatedTableAccount);
        if (account != null) {
            account.unlock();
        }
        return account;
    }

    @Override
    protected Account transferTable(LogicalTable table, TableAccount toAllocate) {
        List tabs;
        TableAccount openAccount = table.getAccount();
        if (openAccount == null && (tabs = table.getBarTabs()) != null && !tabs.isEmpty()) {
            openAccount = tabs.size() == 1 ? (Account)tabs.get(0) : (Account)Dialogs.displaySelectionDialog((String)"Choose the Bartab to transfer items to", (List)tabs);
        }
        if (openAccount == null) {
            return null;
        }
        User user = LoginManager.getInstance().getUser();
        User openAccountUser = openAccount.getUser();
        if (openAccountUser != null && !openAccountUser.equals((Object)user)) {
            Dialogs.displayOkDialog((String)"Unable to Lock Table", (String)("The table could not be locked for transfer, in use by " + openAccount.getUser()));
            return null;
        }
        if (!openAccount.isLocked(user) && !openAccount.lock(user)) {
            Dialogs.displayOkDialog((String)"Unable to Lock Table", (String)("The table could not be locked for transfer, in use by " + openAccount.getUser()));
            return null;
        }
        List transferItems = WaitermateSaveAccount.getInstance().performTransfer((Account)toAllocate, (Account)openAccount, toAllocate.getItems(), false, LoginManager.getEventContext(), false);
        if (toAllocate.hasPayments()) {
            if (!toAllocate.isLocked()) {
                toAllocate.lock(user);
            }
            List transactions = toAllocate.getFinanceTransactions();
            for (FinanceTransaction txn : transactions) {
                openAccount.addFinanceTransaction(txn.nonRevertableTransfer(), transferItems);
            }
            WaitermateSaveAccount.getInstance().closeAccount((Account)toAllocate, false, false, LoginManager.getEventContext());
            WaitermateSaveAccount.getInstance().saveAccount((Account)toAllocate, LoginManager.getEventContext());
        }
        openAccount.lock(user);
        return openAccount;
    }

    @Override
    protected int getStartingPatrons(LogicalTable table, TableAccount tableAccount) {
        return table.getAccount().getNumPatrons();
    }

    @Override
    protected void printAccount(Account account) {
        if (!account.isOnHold()) {
            super.printAccount(account);
        }
    }
}

