/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table.staleaccounts.staleaccountslist;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import ordermate.database.sales.Account;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.Renderer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class StaleAccountRenderer
implements Renderer,
ActionListener {
    private static final DateFormat dateTimeFormat = DateTimeUtils.getDateTimeFormat();
    public final Signal selected = Signals.createSignal(Account.class, (String)"account");

    public Component createComponent() {
        CustomButton button = new CustomButton();
        button.addActionListener((ActionListener)this);
        return button;
    }

    public void setupComponent(Component component, Object object, int index) {
        CustomButton button = (CustomButton)component;
        Account account = (Account)object;
        button.setData((Displayable)account);
        button.setText(this.getTextForButton(account));
    }

    public String getTextForButton(Account account) {
        StringBuilder buffer = new StringBuilder("<html>").append(account.getAccountType().getLabel());
        buffer.append(" - ").append(dateTimeFormat.format(account.getCreationDateTime())).append("<br>");
        buffer.append(account.getRendererLabel());
        if (!StringUtils.isEmpty((String)account.getSource())) {
            buffer.append(" : ").append(account.getSource());
        }
        buffer.append("<br>");
        Price due = account.getDue();
        Price total = account.getTotal();
        Price paid = account.getPaid();
        StringBuilder finance = new StringBuilder("Total: ").append(total);
        if (!Price.ZERO_DOLLAR.equals((Object)paid)) {
            finance.append(" Paid: ").append(paid);
            if (!Price.ZERO_DOLLAR.equals((Object)due)) {
                finance.append(" Due: ").append(due);
            }
        }
        buffer.append(HtmlUtils.boldColor((String)finance.toString(), (String)"gray"));
        buffer.append("</html>");
        return buffer.toString();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CustomButton button = (CustomButton)event.getSource();
        Account account = (Account)button.getData();
        this.selected.emit((Object)account);
    }
}

