/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.selectaccount.table.staleaccounts.staleaccountslist;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.sales.Account;
import ordermate.database.sales.StaleAccountType;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.selectaccount.table.staleaccounts.staleaccountslist.StaleAccountRenderer;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;

public class StaleAccountsList
extends AbstractScreen
implements Refreshable {
    public final Signal back = Signals.createSignal();
    public final Signal account = Signals.createSignal(Account.class, (String)"selectedAccount");
    private CustomScrollPane gui;
    private RendererScrollPaneModel model;
    private StaleAccountRenderer renderer = new StaleAccountRenderer();
    private NavBar nav;
    private StaleAccountType staleAccountType;
    final List<Account> accounts;

    public StaleAccountsList() {
        this.renderer.selected.connect((Object)this, "gotAccount");
        this.model = new RendererScrollPaneModel((Renderer)this.renderer, 3, 8);
        this.gui = new CustomScrollPane((CustomScrollPaneModel)this.model);
        this.gui.setEmptyMessage(Internationalization.getLiteralFor((String)"THERE_ARE_NO_STALE_ACCOUNTS_FOR_THIS_TYPE"));
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.back.connect((Object)this.back, "emit");
        this.nav.back.connect((Object)this, "exitDisplay");
        this.nav.addRight((Component)this.nav.getClearButton());
        this.nav.getClearButton().setText("Refresh");
        this.nav.clear.connect((Object)this, "refresh");
        this.accounts = new ArrayList<Account>();
    }

    void exitDisplay() {
        this.model.emptyComponents();
        this.model.removeAllObjects();
        this.back.emit();
    }

    public void showStaleAccounts(StaleAccountType newStaleAccountType) {
        this.staleAccountType = newStaleAccountType;
        this.showStaleAccounts();
        this.nav.setText(this.staleAccountType.toString());
        this.gui.displayLastPage();
    }

    public void showStaleAccounts() {
        this.refresh();
        this.display();
    }

    public void refresh() {
        this.accounts.clear();
        ProgressDialog.doProgressDialog((Task)new AbstractTask(){

            public String getName() {
                return "Searching database...";
            }

            protected void performTask() throws Exception {
                StaleAccountsList.this.accounts.addAll(PersistenceManager.getObjectList(Account.class, (String)StaleAccountsList.this.staleAccountType.getFunction()));
            }

            protected int getTotalSubTasks() {
                return 1;
            }
        });
        this.model.setObjects(this.accounts);
    }

    void gotAccount(Account theAccount) {
        if (!theAccount.isOpen()) {
            Dialogs.displayOkDialog((String)"The account has already been closed", (String)"Cannot open account");
            this.refresh();
            return;
        }
        User currentUser = LoginManager.getInstance().getUser();
        if (theAccount.isLocked() && currentUser.hasPermission(AllPermissions.UNLOCK_ACCOUNTS)) {
            if (Dialogs.displayChoiceDialog((String)"Unlock Account?", (String)("This account is locked by " + theAccount.getUser() + ". Do you wish to unlock it?"), (boolean)true)) {
                LogicalTable table;
                theAccount.unlock();
                if (theAccount instanceof TableAccount && (table = ((TableAccount)theAccount).getTable()) != null) {
                    table.unlock();
                }
            } else {
                return;
            }
        }
        this.account.emit((Object)theAccount);
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void accountUpdated(Account accountUpdated) {
        if (!accountUpdated.isOpen()) {
            this.accounts.remove(accountUpdated);
        }
        this.model.setObjects(this.accounts);
    }
}

