/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.transaction;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.HtmlReportPanel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.signals.Signal;
import waitermate.gui.screens.transaction.WMFinanceTxnSearchPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.PopupWindow;
import waitermate.guikit.dialogs.ProgressDialog;

public class WMFinanceTxnScreen
extends AbstractScreen {
    public Signal back;
    private NavBar nav;
    private WMFinanceTxnSearchPanel searchPanel = new WMFinanceTxnSearchPanel();
    private RendererScrollPaneModel<FinanceTransaction> model;
    private CustomScrollPane scrolly;
    private JLabel statusLabel;
    private JPanel ui;
    private static final int COLS = 11;
    private static final int ROWS = 8;

    public WMFinanceTxnScreen() {
        this.initMainPanel();
        this.initNavBar();
    }

    private void initMainPanel() {
        this.ui = new JPanel(new BorderLayout());
        this.model = new RendererScrollPaneModel((Renderer)new WMTxnRenderer());
        this.searchPanel.propertyChanged.connect((Object)this, "refresh");
        this.searchPanel.clearSearch.connect((Object)this, "reset");
        this.ui.add((Component)this.searchPanel, "North");
        JPanel centre = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel headers = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(11, 1), 10, 5));
        headers.setOpaque(false);
        topPanel.setBackground(Color.DARK_GRAY);
        headers.add(this.makeHeaderLabel("Date"), new Rectangle(0, 0, 1, 1));
        headers.add(this.makeHeaderLabel("Active?"), new Rectangle(1, 0, 1, 1));
        headers.add(this.makeHeaderLabel("Unit"), new Rectangle(2, 0, 1, 1));
        headers.add(this.makeHeaderLabel("Eftpos"), new Rectangle(3, 0, 2, 1));
        headers.add(this.makeHeaderLabel("Cash Drawer"), new Rectangle(5, 0, 2, 1));
        headers.add(this.makeHeaderLabel("Paid Ex Surc Ex Tip"), new Rectangle(7, 0, 2, 1));
        headers.add(this.makeHeaderLabel("Txn Total"), new Rectangle(9, 0, 2, 1));
        topPanel.add((Component)headers, "Center");
        topPanel.add(Box.createHorizontalStrut(40), "East");
        centre.add((Component)topPanel, "North");
        this.scrolly = new CustomScrollPane(this.model);
        this.scrolly.setColumns(1);
        this.scrolly.setRowsPerPage(8);
        this.scrolly.setDecorationLocation(DecoratorLocation.East);
        this.scrolly.setDecoratorAlwaysVisible(true);
        centre.add((Component)this.scrolly, "Center");
        this.ui.add((Component)centre, "Center");
        this.statusLabel = new JLabel();
        this.ui.add((Component)this.statusLabel, "South");
    }

    private Component makeHeaderLabel(String string) {
        JLabel label = new JLabel(this.htmlifyHeading(string));
        label.setHorizontalAlignment(0);
        return label;
    }

    private void initNavBar() {
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.back = this.nav.back;
    }

    public void reset() {
        this.searchPanel.reset();
        this.model.setObjects(Collections.EMPTY_LIST);
        this.scrolly.setModel(this.model);
    }

    public void display() {
        super.display();
        this.reset();
    }

    public JComponent getMainArea() {
        return this.ui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void refresh() {
        AbstractTask task = new AbstractTask(){

            protected int getTotalSubTasks() {
                return 1;
            }

            protected void performTask() throws Exception {
                final List txns = WMFinanceTxnScreen.this.searchPanel.getSearcher().search();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WMFinanceTxnScreen.this.model.setObjects(txns);
                        WMFinanceTxnScreen.this.scrolly.setModel((CustomScrollPaneModel)WMFinanceTxnScreen.this.model);
                        WMFinanceTxnScreen.this.statusLabel.setText(" " + txns.size() + " result" + (txns.size() == 1 ? "" : "s"));
                    }
                });
            }

            public String getName() {
                return "Searching...";
            }
        };
        ProgressDialog.doProgressDialog((Task)task);
    }

    private String htmlifyHeading(String text) {
        return "<html><h5>" + text + "</h5></html>";
    }

    private String htmlify(String text) {
        return "<html>" + text + "</html>";
    }

    class WMTxnRendererPanel
    extends JPanel {
        private Font font = new Font("Monospaced", 0, 12);
        private Color DELETED = Color.DARK_GRAY;
        private Color ACTIVE = Color.GRAY;
        private JLabel dateLabel;
        private JLabel activeLabel;
        private JLabel subtypeLabel;
        private JLabel eftLabel;
        private JLabel cdLabel;
        private JLabel paidExLabel;
        private JLabel paidTotalLabel;
        private FinanceTransaction txn;

        public WMTxnRendererPanel() {
            this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(11, 1), 10, 5));
            this.dateLabel = this.makeLabel(false);
            this.add((Component)this.dateLabel, new Rectangle(0, 0, 1, 1));
            this.activeLabel = this.makeLabel(false);
            this.add((Component)this.activeLabel, new Rectangle(1, 0, 1, 1));
            this.subtypeLabel = this.makeLabel(false);
            this.add((Component)this.subtypeLabel, new Rectangle(2, 0, 1, 1));
            this.eftLabel = this.makeLabel(false);
            this.add((Component)this.eftLabel, new Rectangle(3, 0, 2, 1));
            this.cdLabel = this.makeLabel(false);
            this.add((Component)this.cdLabel, new Rectangle(5, 0, 2, 1));
            this.paidExLabel = this.makeLabel(true);
            this.add((Component)this.paidExLabel, new Rectangle(7, 0, 2, 1));
            this.paidTotalLabel = this.makeLabel(true);
            this.add((Component)this.paidTotalLabel, new Rectangle(9, 0, 2, 1));
        }

        private JLabel makeLabel(boolean isNumber) {
            JLabel label = new JLabel();
            if (isNumber) {
                label.setHorizontalAlignment(4);
                label.setFont(this.font);
            } else {
                label.setHorizontalAlignment(2);
            }
            return label;
        }

        public void setTransaction(FinanceTransaction txn) {
            this.txn = txn;
            if (txn != null) {
                this.dateLabel.setText(WMFinanceTxnScreen.this.htmlify(DateTimeUtils.getConsistent24HourReportDateFormat().format(txn.getCreationTime())));
                this.activeLabel.setText("ACTIVE".equals(txn.getSystemState()) ? "Yes" : "No");
                if ("ACTIVE".equals(txn.getSystemState())) {
                    this.setBackground(this.ACTIVE);
                } else {
                    this.setBackground(this.DELETED);
                }
                this.subtypeLabel.setText(WMFinanceTxnScreen.this.htmlify(txn.getSubType().getLabel()));
                if (txn instanceof EftposTransaction) {
                    this.eftLabel.setText(((EftposTransaction)txn).getVirtualEftpos() != null ? WMFinanceTxnScreen.this.htmlify(((EftposTransaction)txn).getVirtualEftpos().toString()) : "");
                } else {
                    this.eftLabel.setText("");
                }
                this.eftLabel.setHorizontalAlignment(4);
                this.cdLabel.setText(WMFinanceTxnScreen.this.htmlify(txn.getCashDrawer().getLabel()));
                this.paidExLabel.setText(txn.getPaidExSurchExTip().toString());
                this.paidTotalLabel.setText(txn.getPaidTotal().toString());
            } else {
                this.dateLabel.setText("");
                this.activeLabel.setText("");
                this.subtypeLabel.setText("");
                this.eftLabel.setText("");
                this.cdLabel.setText("");
                this.paidExLabel.setText("");
                this.paidTotalLabel.setText("");
            }
        }
    }

    class WMTxnRenderer
    implements Renderer<WMTxnRendererPanel, FinanceTransaction>,
    MouseListener {
        WMTxnRenderer() {
        }

        public WMTxnRendererPanel createComponent() {
            WMTxnRendererPanel panel = new WMTxnRendererPanel();
            panel.addMouseListener(this);
            return panel;
        }

        public void setupComponent(WMTxnRendererPanel component, FinanceTransaction txn, int index) {
            component.setTransaction(txn);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            WMTxnRendererPanel panel = (WMTxnRendererPanel)e.getSource();
            if (panel.txn != null) {
                ArrayList<String> data = new ArrayList<String>();
                FinanceTransaction txn = panel.txn;
                this.addData(data, "Date", DateTimeUtils.getConsistent24HourReportDateFormat().format(txn.getCreationTime()));
                this.addData(data, "Type", txn.getType() + " - " + txn.getSubType().getLabel());
                if (txn instanceof EftposTransaction) {
                    this.addData(data, "Eftpos", ((EftposTransaction)txn).getVirtualEftpos() != null ? ((EftposTransaction)txn).getVirtualEftpos().toString() : "None");
                }
                this.addData(data, "Source", txn.getSource() == null ? "" : txn.getSource());
                this.addData(data, "CashDrawer", txn.getCashDrawer().getLabel());
                this.addData(data, "Terminal", txn.getTerminal().getLabel());
                this.addData(data, "User", txn.getUser().getLabel());
                if (!txn.getDebtorPayments().isEmpty()) {
                    this.addData(data, "Debtor", ((DebtorPayment)txn.getDebtorPayments().get(0)).getLabel());
                } else if (txn.getPayoffGroup() != null) {
                    this.addData(data, "Account", txn.getPayoffGroup().getAccount().getLabel());
                }
                this.addData(data, "Ref #", txn.getTransactionReference() == null ? "" : txn.getTransactionReference());
                this.addData(data, "Paid Ex Surcharge Ex Tip", txn.getPaidExSurchExTip().toString());
                this.addData(data, "Surcharge", txn.getSurcharge() != null ? txn.getSurcharge().toString() : "");
                this.addData(data, "Tip", txn.getTip() != null ? txn.getTip().toString() : "");
                this.addData(data, "Cashout", txn.getCashOut() != null ? txn.getCashOut().toString() : "");
                this.addData(data, "Paid", txn.getPaid().toString());
                this.addData(data, "Paid Ex Surcharge Inc Tip", txn.getPaidExSurchIncTip().toString());
                this.addData(data, "Txn Total", txn.getPaidTotal().toString());
                this.addData(data, "Tendered", txn.getTendered().toString());
                this.addData(data, "Change", txn.getChange().toString());
                HtmlReportPanel report = new HtmlReportPanel("Finance Transaction " + txn.getID() + (txn.isActive() ? "" : " (Inactive)"));
                report.setListData(data);
                PopupWindow window = new PopupWindow();
                window.setCancelButtonVisible(false);
                window.setOkButtonVisible(true);
                window.setComponent((JComponent)report);
                window.start();
            }
        }

        private void addData(List<String> data, String title, String value) {
            data.add("<b>" + title + "</b>: " + value);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

