/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.transaction;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import ordermate.database.searchers.finance.FinanceTransactionSearcher;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.search.AbstractWaitermateSearchPanel;
import waitermate.guikit.search.searchfield.WaitermateDateRangePanel;
import waitermate.guikit.search.searchfield.WaitermateDateRangeSearchField;

class WMFinanceTxnSearchPanel
extends AbstractWaitermateSearchPanel
implements ActionListener,
Refreshable {
    private JButton clearButton;
    private WaitermateDateRangePanel dateRangeField;
    private FinanceTransactionSearcher txnSearcher;
    private RefreshAction refresh;

    @Override
    protected void setupComponents() {
        this.setLayout(new BoxLayout(this, 0));
        this.refresh = new RefreshAction((Refreshable)this);
        this.txnSearcher = new FinanceTransactionSearcher();
        WaitermateDateRangeSearchField field = this.setupDateRangeSearchField();
        field.getGuiComponent().setPreferredSize(new Dimension(250, 80));
        field.getGuiComponent().setMaximumSize(new Dimension(250, 80));
        this.setupClearButton();
        this.add(Box.createHorizontalStrut(40));
        this.add(field.getGuiComponent());
        this.add(Box.createHorizontalGlue());
        this.add(this.clearButton);
    }

    private WaitermateDateRangeSearchField setupDateRangeSearchField() {
        this.dateRangeField = new WaitermateDateRangePanel(Calendar.getInstance(), Calendar.getInstance(), "From Date", "To Date", this.refresh);
        WaitermateDateRangeSearchField dateField = new WaitermateDateRangeSearchField(Internationalization.getLiteralFor((String)"DATE_RANGE"), (IRangedSearchFilter)this.txnSearcher.getTradingDayFilter(), null, (Action)this.refresh, this.dateRangeField);
        return dateField;
    }

    private void setupClearButton() {
        this.clearButton = new JButton();
        OrderMateTheme.setupNavBarButton((AbstractButton)this.clearButton);
        this.clearButton.setText(Internationalization.getLiteralFor((String)"CLEAR_SEARCH"));
        this.clearButton.setIcon(IconLoader.get((String)"/waitermate/guikit/images/clear.png"));
        this.clearButton.addActionListener(this);
    }

    public FinanceTransactionSearcher getSearcher() {
        return this.txnSearcher;
    }

    @Override
    public void reset() {
        Date now = new Date();
        this.dateRangeField.setDates(now, now);
        this.refresh.doRefresh();
    }

    public void refresh() {
        this.txnSearcher.getTradingDayFilter().setStart((Comparable)this.dateRangeField.getStartDate());
        this.txnSearcher.getTradingDayFilter().setEnd((Comparable)this.dateRangeField.getEndDate());
        this.emitChange();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.clearButton) {
            this.clearSearch.emit();
            return;
        }
        this.emitChange();
    }

    public void emitChange() {
        this.propertyChanged.emit();
    }
}

