/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.tablelayout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ordermate.database.EventContext;
import ordermate.database.hardware.GTL;
import ordermate.database.queries.tables.TableGroupQueries;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.gui.screens.selectaccount.table.UnallocatedTableAccountSelection;
import waitermate.gui.tablelayout.GTLMode;
import waitermate.gui.tablelayout.SectionDisplayPanel;
import waitermate.gui.tablelayout.SectionEditorPanel;

public class RestaurantDisplayPanel
extends JPanel
implements ChangeListener {
    public final Signal<LogicalTable, ?, ?, ?, ?> tableSelected = Signals.createSignal(LogicalTable.class, (String)"selectedTable");
    public final Signal<SectionEditorPanel, ?, ?, ?, ?> tableGroupSelected = Signals.createSignal(SectionEditorPanel.class, (String)"selectedSectionPanel");
    public final Signal<?, ?, ?, ?, ?> tableGroupUnlocked = Signals.createSignal();
    public final Signal<?, ?, ?, ?, ?> tableMoved = Signals.createSignal();
    public final Signal<?, ?, ?, ?, ?> tableSplit = Signals.createSignal();
    public final Signal<?, ?, ?, ?, ?> tableJoined = Signals.createSignal();
    public final Signal<PhysicalTable, ?, ?, ?, ?> createTable = Signals.createSignal(PhysicalTable.class, (String)"protoType");
    public final Signal<LogicalTable, ?, ?, ?, ?> deleteTable = Signals.createSignal(LogicalTable.class, (String)"toRemove");
    public final Signal<?, ?, ?, ?, ?> preMove = Signals.createSignal();
    private boolean useScrollPane = false;
    private GTLMode state;
    private List<SectionEditorPanel> sectionPanels = new ArrayList<SectionEditorPanel>();
    private JTabbedPane tabs;
    private SectionEditorPanel currentSectionPanel;
    private final UnallocatedTableAccountSelection unallocatedSection;
    private GTL gtl;
    private boolean allowsTableNameChange = false;
    private boolean includeInactiveSections = false;

    public RestaurantDisplayPanel(boolean useScrollPanes, UnallocatedTableAccountSelection unallocatedSelector, boolean includeInactiveSections, GTL gtl) {
        this.gtl = gtl;
        this.unallocatedSection = unallocatedSelector;
        this.useScrollPane = useScrollPanes;
        this.setLayout(new BorderLayout());
        this.state = GTLMode.Select;
        this.tabs = new JTabbedPane(3);
        this.tabs.setName("Table Sections");
        OrderMateTheme.setupTabbedPane((JTabbedPane)this.tabs);
        this.tabs.setFont(OrderMateTheme.getLargeFont());
        this.includeInactiveSections = includeInactiveSections;
        List<TableGroup> allTableGroups = this.getSections();
        if (allTableGroups.size() == 0) {
            TableGroup tableGroup = new TableGroup("DefaultSection");
            tableGroup.save();
            allTableGroups.add(tableGroup);
        }
        if (this.unallocatedSection != null) {
            this.tabs.add("Unallocated", this.unallocatedSection);
        }
        for (TableGroup tableGroup : allTableGroups) {
            this.addTableGroup(tableGroup);
        }
        this.tabs.addChangeListener(this);
        this.setCurrentTableGroup(0);
        this.add((Component)this.tabs, "Center");
    }

    public void renameCurrentTab(String newName) {
        this.tabs.setTitleAt(this.tabs.getSelectedIndex(), newName);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshCurrentSection();
        if (this.currentSectionPanel != null) {
            this.tableGroupSelected.emit((Object)this.currentSectionPanel);
            this.currentSectionPanel.repaint();
        }
    }

    private SectionEditorPanel findSectionPanel(Component currentComponent) {
        SectionEditorPanel retval;
        if (currentComponent instanceof JScrollPane) {
            JScrollPane scroller = (JScrollPane)currentComponent;
            retval = (SectionEditorPanel)scroller.getViewport().getView();
        } else if (currentComponent instanceof SectionEditorPanel) {
            retval = (SectionEditorPanel)currentComponent;
        } else {
            retval = null;
            String componentClass = currentComponent != null ? currentComponent.getClass().getName() : "[null]";
            WaiterMate.LOG.error("Unrecognised component in RestaurantDisplayPanel!", (Throwable)new IllegalStateException("Component type " + componentClass + "not recognised."));
        }
        return retval;
    }

    public void refresh() {
        this.refreshSections();
        this.refreshCurrentSection();
    }

    public void refreshUnallocatedSection() {
        if (this.unallocatedSection != null && this.tabs.getSelectedComponent().equals(this.unallocatedSection)) {
            this.unallocatedSection.refresh();
        }
    }

    private void refreshSections() {
        List<TableGroup> activeSections = this.getSections();
        Collections.sort(activeSections);
        List<TableGroup> displayingSections = this.getDisplayingSections();
        Collections.sort(displayingSections);
        boolean reloadSections = activeSections.size() != displayingSections.size();
        for (int i = 0; i < activeSections.size() && !reloadSections; ++i) {
            TableGroup tableGroup = activeSections.get(i);
            TableGroup displayedSection = displayingSections.get(i);
            if (tableGroup.getSequence() == displayedSection.getSequence()) continue;
            WaiterMate.LOG.info("Reloading sections as sequences vary at :" + i + " for: " + tableGroup + " and " + displayedSection);
            reloadSections = true;
        }
        if (reloadSections) {
            if (activeSections.size() == 0) {
                TableGroup tableGroup = new TableGroup("DefaultSection");
                tableGroup.save();
                activeSections.add(tableGroup);
            }
            this.tabs.removeChangeListener(this);
            for (Component component : this.sectionPanels) {
                this.tabs.remove(component);
            }
            this.sectionPanels.clear();
            this.tabs.addChangeListener(this);
            for (TableGroup tableGroup : activeSections) {
                this.addTableGroup(tableGroup);
            }
        }
    }

    private List<TableGroup> getSections() {
        if (this.includeInactiveSections) {
            return TableGroupQueries.getTableGroups();
        }
        return TableGroup.getActiveTableGroups((EventContext)LoginManager.getEventContext());
    }

    private void refreshCurrentSection() {
        Component selectedComponent = this.tabs.getSelectedComponent();
        if (selectedComponent != null && selectedComponent.equals(this.unallocatedSection)) {
            this.unallocatedSection.refresh();
            return;
        }
        this.currentSectionPanel = this.findSectionPanel(this.tabs.getSelectedComponent());
        TableGroup tableGroup = this.currentSectionPanel.getTableGroup();
        if (tableGroup.isReloadRequired()) {
            this.currentSectionPanel.refreshTableGroup();
        }
        this.currentSectionPanel.refreshReservations();
        this.currentSectionPanel.resetState();
        int selIndex = this.tabs.getSelectedIndex();
        this.tabs.setTitleAt(selIndex, this.currentSectionPanel.getTableGroup().getName());
    }

    private List<TableGroup> getDisplayingSections() {
        ArrayList<TableGroup> sections = new ArrayList<TableGroup>();
        for (SectionEditorPanel panel : this.sectionPanels) {
            sections.add(panel.getTableGroup());
        }
        return sections;
    }

    public int getNumSections() {
        return this.sectionPanels.size();
    }

    public GTLMode getMode() {
        return this.state;
    }

    public void setGridEnabled(boolean b) {
        for (int i = 0; i < this.sectionPanels.size(); ++i) {
            SectionEditorPanel panel = this.sectionPanels.get(i);
            panel.setGridEnabled(b);
        }
    }

    public void setProtoTypeTable(PhysicalTable table) {
        for (int i = 0; i < this.sectionPanels.size(); ++i) {
            SectionEditorPanel panel = this.sectionPanels.get(i);
            panel.setProtoTypeNewTable(table);
        }
    }

    public void setMode(GTLMode mode) {
        this.state = mode;
        for (int i = 0; i < this.sectionPanels.size(); ++i) {
            SectionEditorPanel panel = this.sectionPanels.get(i);
            panel.setGtlMode(mode);
        }
    }

    public boolean isTableNameChangeAllowed() {
        return this.allowsTableNameChange;
    }

    public void setTableNameChangeAllowed(boolean b) {
        this.allowsTableNameChange = b;
        for (int i = 0; i < this.sectionPanels.size(); ++i) {
            SectionEditorPanel panel = this.sectionPanels.get(i);
            panel.setTableNameChangeAllowed(b);
        }
    }

    void gotCreateTable(PhysicalTable protoType) {
        this.createTable.emit((Object)protoType);
    }

    void gotDeleteTable(LogicalTable toDelete) {
        this.deleteTable.emit((Object)toDelete);
    }

    public void addTableGroup(TableGroup tableGroup) {
        SectionEditorPanel newPanel = new SectionEditorPanel(tableGroup, this.state, this.gtl);
        newPanel.unlockPressed.connect((Object)this, "gotTableGroupUnlocked");
        newPanel.tableSelected.connect((Object)this, "gotTable");
        newPanel.createTable.connect((Object)this, "gotCreateTable");
        newPanel.deleteTable.connect((Object)this, "gotDeleteTable");
        newPanel.tableJoined.connect(this.tableJoined);
        newPanel.tableSplit.connect(this.tableSplit);
        newPanel.tableMoved.connect(this.tableMoved);
        newPanel.preMove.connect(this.preMove);
        newPanel.setTableNameChangeAllowed(this.allowsTableNameChange);
        this.sectionPanels.add(newPanel);
        Collections.sort(this.sectionPanels, SectionPanelComparator.instance);
        JComponent addedComponent = null;
        if (this.useScrollPane) {
            JScrollPane scroller = new JScrollPane(newPanel);
            OrderMateTheme.setupScrollPane((JScrollPane)scroller);
            addedComponent = scroller;
        } else {
            addedComponent = newPanel;
        }
        this.tabs.insertTab(tableGroup.getName(), null, addedComponent, null, this.sectionPanels.indexOf(newPanel));
        this.tabs.setSelectedComponent(addedComponent);
        this.revalidate();
    }

    public void removeCurrentTableGroup() {
        SectionEditorPanel currentSecPanel = this.getCurrentSectionPanel();
        int currentIndex = this.tabs.getSelectedIndex();
        this.sectionPanels.remove(currentSecPanel);
        this.tabs.remove(currentIndex);
        this.setCurrentTableGroup(0);
        this.revalidate();
    }

    void gotTable(LogicalTable selectedTable) {
        this.tableSelected.emit((Object)selectedTable);
    }

    public void setCurrentTableGroup(int which) {
        this.tabs.setSelectedIndex(which);
        this.refreshCurrentSection();
    }

    public void setCurrentTableGroup(TableGroup tableGroup) {
        for (int i = 0; i < this.sectionPanels.size(); ++i) {
            SectionEditorPanel sectionPanel = this.sectionPanels.get(i);
            if (!sectionPanel.getTableGroup().equals((Object)tableGroup)) continue;
            this.setCurrentTableGroup(i);
        }
    }

    void gotTableGroupUnlocked() {
        OrderMateTheme.setTabColour((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex(), null);
        this.tableGroupUnlocked.emit();
    }

    public SectionEditorPanel getCurrentSectionPanel() {
        return this.currentSectionPanel;
    }

    public TableGroup getCurrentTableGroup() {
        if (this.currentSectionPanel != null) {
            return this.currentSectionPanel.getTableGroup();
        }
        return null;
    }

    public void setAllowTableSectionUnlocking(boolean allowIt) {
        for (SectionEditorPanel panel : this.sectionPanels) {
            panel.setAllowUnlockSection(allowIt);
        }
    }

    public boolean isInterfaceLocked() {
        return this.getCurrentSectionPanel() != null && this.getCurrentSectionPanel().isInterfaceLocked();
    }

    public void setInterfaceLocked(boolean locked, String dialogText, String unlockButtonText) {
        if (this.getCurrentSectionPanel() != null) {
            this.getCurrentSectionPanel().setInterfaceLocked(locked, dialogText, unlockButtonText);
        }
    }

    public void setInterfaceLocked(boolean locked) {
        if (this.getCurrentSectionPanel() != null) {
            this.getCurrentSectionPanel().setInterfaceLocked(locked);
        }
    }

    public List<TableGroup> getTableGroups() {
        ArrayList<TableGroup> tableGroups = new ArrayList<TableGroup>();
        for (SectionDisplayPanel sectionDisplayPanel : this.sectionPanels) {
            tableGroups.add(sectionDisplayPanel.getTableGroup());
        }
        return tableGroups;
    }

    public boolean isGridEnabled() {
        for (SectionDisplayPanel sectionDisplayPanel : this.sectionPanels) {
            if (!sectionDisplayPanel.isGridEnabled()) continue;
            return true;
        }
        return false;
    }

    public void showUnallocatedTableSection() {
        if (this.unallocatedSection == null) {
            throw new IllegalStateException("Unallocated table section is not initialized");
        }
        this.tabs.setSelectedComponent(this.unallocatedSection);
    }

    public void terminalChanged() {
        for (SectionDisplayPanel sectionDisplayPanel : this.sectionPanels) {
            sectionDisplayPanel.terminalChanged();
        }
    }

    private static class SectionPanelComparator
    implements Comparator {
        public static final Comparator instance = new SectionPanelComparator();

        private SectionPanelComparator() {
        }

        public int compare(Object o1, Object o2) {
            SectionEditorPanel panel1 = (SectionEditorPanel)o1;
            SectionEditorPanel panel2 = (SectionEditorPanel)o2;
            if (panel1.getTableGroup().getSequence() == panel2.getTableGroup().getSequence()) {
                return panel1.getTableGroup().getID().compareTo(panel2.getTableGroup().getID());
            }
            if (panel1.getTableGroup().getSequence() < panel2.getTableGroup().getSequence()) {
                return -1;
            }
            return 1;
        }
    }
}

