/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.tablelayout;

import au.com.ordermate.util.image.IconLoader;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import ordermate.OrderMate;
import ordermate.database.hardware.GTL;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.apache.logging.log4j.Level;
import waitermate.gui.tablelayout.GTLMode;
import waitermate.gui.tablelayout.SectionDisplayPanel;

public class SectionEditorPanel
extends SectionDisplayPanel {
    public final Signal<?, ?, ?, ?, ?> unlockPressed = Signals.createSignal();
    public final Signal<LogicalTable, ?, ?, ?, ?> tableSelected = Signals.createSignal(LogicalTable.class, (String)"selectedTable");
    public final Signal<?, ?, ?, ?, ?> tableMoved = Signals.createSignal();
    public final Signal<?, ?, ?, ?, ?> tableSplit = Signals.createSignal();
    public final Signal<?, ?, ?, ?, ?> tableJoined = Signals.createSignal();
    public final Signal<PhysicalTable, ?, ?, ?, ?> createTable = Signals.createSignal(PhysicalTable.class, (String)"protoType");
    public final Signal<LogicalTable, ?, ?, ?, ?> deleteTable = Signals.createSignal(LogicalTable.class, (String)"toRemove");
    public final Signal<?, ?, ?, ?, ?> paletteChange = Signals.createSignal();
    public final Signal<?, ?, ?, ?, ?> preMove = Signals.createSignal();
    private boolean interfaceLocked = false;
    private JPanel unlockPanel;
    private JLabel unlockLabel;
    private StandardSecurityDecorator unlockButton;
    private LogicalTable mouseOverTable;
    private LogicalTable draggedTable;
    private PhysicalTable draggedPhysicalTable;
    private int dragOffsetX;
    private int dragOffsetY;
    private int originalPtX;
    private int originalPtY;
    private int mouseX;
    private int mouseY;
    private GTLMode gtlMode;
    private boolean useMouseMovement = true;
    private boolean allowNameChange = false;
    private boolean allowUnlock = false;
    private PhysicalTable protoTypeNewTable = new PhysicalTable();
    private PhysicalTable fromTable;
    private final SelectMouseAdapter selectML;
    private final MoveMouseAdapter moveML;
    private final MoveNoLinkMouseAdapter moveNoLinkML;
    private final CreateMouseAdapter createML;
    private final DeleteMouseAdapter delML;
    private final LinkMouseAdapter linkML;
    private final UnLinkMouseAdapter unlinkML;

    public SectionEditorPanel(TableGroup tableGroup, GTLMode gtlMode, GTL gtl) {
        this(tableGroup, gtlMode, false, gtl);
    }

    public SectionEditorPanel(TableGroup tGroup, GTLMode gtlMode, boolean canUnlock, GTL gtl) {
        super(tGroup, gtl);
        this.gtlMode = gtlMode;
        this.allowUnlock = canUnlock;
        JButton theUnlockButton = new JButton("Unlock", IconLoader.get((String)"/waitermate/images/lock.png"));
        theUnlockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SectionEditorPanel.this.setInterfaceLocked(false);
                SectionEditorPanel.this.unlockPressed.emit();
            }
        });
        this.unlockButton = new StandardSecurityDecorator((JComponent)theUnlockButton, AllPermissions.UNLOCK_TABLE_GROUP);
        this.unlockLabel = new JLabel("   Currently locked");
        this.unlockPanel = new JPanel(new BorderLayout());
        this.unlockButton.setEnabled(this.allowUnlock);
        this.unlockPanel.add((Component)this.unlockButton, "East");
        this.unlockPanel.add((Component)this.unlockLabel, "Center");
        this.unlockPanel.setBorder(BorderFactory.createLineBorder(null));
        this.unlockPanel.setVisible(false);
        this.add(this.unlockPanel);
        this.selectML = new SelectMouseAdapter();
        this.moveML = new MoveMouseAdapter();
        this.moveNoLinkML = new MoveNoLinkMouseAdapter();
        this.createML = new CreateMouseAdapter();
        this.delML = new DeleteMouseAdapter();
        this.linkML = new LinkMouseAdapter();
        this.unlinkML = new UnLinkMouseAdapter();
        this.addMouseListener(this.selectML);
        this.addMouseMotionListener(this.selectML);
        this.addMouseListener(this.moveML);
        this.addMouseMotionListener(this.moveML);
        this.addMouseListener(this.moveNoLinkML);
        this.addMouseMotionListener(this.moveNoLinkML);
        this.addMouseListener(this.createML);
        this.addMouseMotionListener(this.createML);
        this.addMouseListener(this.delML);
        this.addMouseMotionListener(this.delML);
        this.addMouseListener(this.linkML);
        this.addMouseMotionListener(this.linkML);
        this.addMouseListener(this.unlinkML);
    }

    public void setGTLMode(GTLMode mode) {
        this.fromTable = null;
        this.gtlMode = mode;
    }

    public boolean isTableNameChangeAllowed() {
        return this.allowNameChange;
    }

    public void setTableNameChangeAllowed(boolean b) {
        this.allowNameChange = b;
    }

    @Override
    public boolean isInterfaceLocked() {
        return this.interfaceLocked;
    }

    public void setInterfaceLocked(boolean locked, String dialogText, String unlockButtonText) {
        this.interfaceLocked = locked;
        this.unlockButton.setEnabled(!locked || this.allowUnlock);
        if (dialogText != null) {
            this.unlockLabel.setText("   " + dialogText);
        }
        if (unlockButtonText != null) {
            ((AbstractButton)this.unlockButton.getDecorateComponent()).setText(unlockButtonText);
        }
    }

    public void setInterfaceLocked(boolean locked) {
        this.setInterfaceLocked(locked, "Already locked by " + this.getTableGroup().getUser(), "Unlock");
    }

    public void resetState() {
        this.mouseOverTable = null;
        this.draggedTable = null;
        this.setDraggedTable(null);
        this.dragOffsetY = 0;
        this.dragOffsetX = 0;
        this.originalPtY = 0;
        this.originalPtX = 0;
        this.requestFocus();
        this.repaint();
    }

    private void snapMouseXY() {
        int remX = (this.mouseX - this.dragOffsetX) % 24;
        int remY = (this.mouseY - this.dragOffsetY) % 24;
        if (remX < 15) {
            this.mouseX -= remX;
        } else if (remX - 24 > -15) {
            this.mouseX += 24 - remX;
        }
        if (remY < 15) {
            this.mouseY -= remY;
        } else if (remY - 24 > -15) {
            this.mouseY += 24 - remY;
        }
    }

    public LogicalTable getDraggedTable() {
        return this.draggedTable;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g, false);
        Graphics2D g2 = (Graphics2D)g;
        int tableWidth = this.getProtoTypeNewTable().getTableImageWidth();
        int tableHeight = this.getProtoTypeNewTable().getTableImageHeight();
        if (this.gtlMode.equals((Object)GTLMode.Link) && this.fromTable != null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(this.linkOuterStroke);
            g2.setColor(Color.BLACK);
            g2.drawLine(this.originalPtX, this.originalPtY, this.mouseX, this.mouseY);
            g2.setStroke(new BasicStroke(3.0f));
            g2.setColor(Color.CYAN);
            g2.drawLine(this.originalPtX, this.originalPtY, this.mouseX, this.mouseY);
            g2.setStroke(this.basicStroke);
        }
        if (this.mouseOverTable != null) {
            Rectangle mouseOverTableRect = this.mouseOverTable.getBoundingRect();
            int selectX = mouseOverTableRect.x;
            int selectY = mouseOverTableRect.y;
            int selectW = mouseOverTableRect.width;
            int selectH = mouseOverTableRect.height;
            if (this.gtlMode.equals((Object)GTLMode.Delete)) {
                g.setColor(Color.red);
                g.drawRect(selectX, selectY, selectW, selectH);
                g.drawLine(selectX, selectY, selectX + selectW, selectY + selectH);
                g.drawLine(selectX + selectW, selectY, selectX, selectY + selectH);
            }
            if ((this.gtlMode.equals((Object)GTLMode.Move) || this.gtlMode.equals((Object)GTLMode.Link) || this.gtlMode.equals((Object)GTLMode.MovePhysical)) && this.draggedTable != null) {
                if (!(this.mouseOverTable.isLocked() || this.draggedTable.hasAccount() && this.mouseOverTable.hasAccount())) {
                    Rectangle nearest = this.mouseOverTable.getNearestAdjacentCell(this.draggedTable.getBoundingRect());
                    if (nearest != null) {
                        g.setColor(Color.GREEN);
                        g2.draw(nearest);
                        Composite prevComp = g2.getComposite();
                        AlphaComposite newComp = AlphaComposite.getInstance(3, 0.1f);
                        g2.setComposite(newComp);
                        g2.fill(nearest);
                        g.setColor(Color.BLUE);
                        g2.fill(this.mouseOverTable.getBoundingRect());
                        g2.setComposite(prevComp);
                    }
                } else {
                    g.setColor(Color.RED);
                    g.drawRect(selectX, selectY, selectW, selectH);
                    g.drawLine(selectX, selectY, selectX + selectW, selectY + selectH);
                    g.drawLine(selectX + selectW, selectY, selectX, selectY + selectH);
                    Composite prevComp = g2.getComposite();
                    AlphaComposite newComp = AlphaComposite.getInstance(3, 0.3f);
                    g2.setComposite(newComp);
                    g.fillRect(selectX, selectY, selectW, selectH);
                    g2.setComposite(prevComp);
                }
            }
        }
        if (this.gtlMode.equals((Object)GTLMode.Create) && !this.isInterfaceLocked()) {
            int newTableX = this.mouseX - tableWidth / 2;
            int newTableY = this.mouseY - tableHeight / 2;
            if (this.mouseOverTable == null && this.tableGroupContainsRect(newTableX, newTableY, tableWidth, tableHeight)) {
                g.setColor(Color.green);
                g.drawRect(newTableX, newTableY, tableWidth, tableHeight);
                Composite prevComp = g2.getComposite();
                AlphaComposite newComp = AlphaComposite.getInstance(3, 0.4f);
                g2.setComposite(newComp);
                g2.drawImage(this.getProtoTypeNewTable().getTableImage().getImage(), newTableX, newTableY, this);
                g2.setComposite(prevComp);
            } else {
                g.setColor(Color.red);
                g.drawRect(this.mouseX - tableWidth / 2, this.mouseY - tableHeight / 2, tableWidth, tableHeight);
                g.drawLine(this.mouseX - tableWidth / 2, this.mouseY - tableHeight / 2, this.mouseX + tableWidth / 2, this.mouseY + tableHeight / 2);
                g.drawLine(this.mouseX + tableWidth / 2, this.mouseY - tableHeight / 2, this.mouseX - tableWidth / 2, this.mouseY + tableHeight / 2);
                Composite prevComp = g2.getComposite();
                AlphaComposite newComp = AlphaComposite.getInstance(3, 0.3f);
                g2.setComposite(newComp);
                g.fillRect(this.mouseX - tableWidth / 2, this.mouseY - tableHeight / 2, tableWidth, tableHeight);
                g2.setComposite(prevComp);
            }
        }
        if (this.isInterfaceLocked()) {
            this.paintFadeRect(g2);
        }
        if (this.isInterfaceLocked()) {
            int unlockPanelWidth = 400;
            int unlockPanelHeight = 64;
            int bgWidth = Math.min(this.getBackgroundImage().getWidth(this), this.getWidth());
            int bgHeight = Math.min(this.getBackgroundImage().getHeight(this), this.getHeight());
            this.unlockPanel.setSize(400, 64);
            this.unlockPanel.setLocation(bgWidth / 2 - 200, bgHeight / 2 - 32);
            this.unlockPanel.setVisible(true);
        } else {
            this.unlockPanel.setVisible(false);
        }
    }

    private void setMouseOverTable(PhysicalTable t) {
        this.setMouseOverTable(t != null ? t.getLogicalTable() : null);
    }

    private void clearMouseOverTable() {
        this.setMouseOverTable((LogicalTable)null);
    }

    private int getCurrentSelectedTableWidth() {
        if (this.draggedTable != null) {
            return this.draggedTable.getBoundingRect().width;
        }
        return this.getProtoTypeNewTable().getTableImageWidth();
    }

    private int getCurrentSelectedTableHeight() {
        if (this.draggedTable != null) {
            return this.draggedTable.getBoundingRect().height;
        }
        return this.getProtoTypeNewTable().getTableImageHeight();
    }

    private void setMouseOverTable(LogicalTable t) {
        Rectangle boundingRect;
        int TABLE_WIDTH = this.getCurrentSelectedTableWidth() + 1;
        int TABLE_HEIGHT = this.getCurrentSelectedTableHeight() + 1;
        if (this.mouseOverTable != null) {
            boundingRect = this.mouseOverTable.getBoundingRect();
            this.repaint(boundingRect.x - TABLE_WIDTH, boundingRect.y - TABLE_HEIGHT, boundingRect.width + TABLE_WIDTH + TABLE_WIDTH, boundingRect.height + TABLE_HEIGHT + TABLE_HEIGHT);
        }
        if (t != null) {
            boundingRect = t.getBoundingRect();
            this.repaint(boundingRect.x - TABLE_WIDTH, boundingRect.y - TABLE_HEIGHT, boundingRect.width + TABLE_WIDTH + TABLE_WIDTH, boundingRect.height + TABLE_HEIGHT + TABLE_HEIGHT);
        }
        this.mouseOverTable = t;
    }

    private void setDraggedTable(LogicalTable t) {
        this.draggedTable = t;
    }

    public void setAllowUnlockSection(boolean allowIt) {
        this.allowUnlock = allowIt;
        this.unlockButton.setEnabled(this.allowUnlock);
    }

    public void setProtoTypeNewTable(PhysicalTable protoType) {
        this.protoTypeNewTable = protoType;
    }

    private PhysicalTable getProtoTypeNewTable() {
        return this.protoTypeNewTable;
    }

    public void setGtlMode(GTLMode newMode) {
        this.fromTable = null;
        this.draggedPhysicalTable = null;
        this.gtlMode = newMode;
    }

    private class DeleteMouseAdapter
    extends StateMouseAdapter {
        private DeleteMouseAdapter() {
            this.setMyState(GTLMode.Delete);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                SectionEditorPanel.this.setMouseOverTable(SectionEditorPanel.this.getTableAt(SectionEditorPanel.this.mouseX, SectionEditorPanel.this.mouseY));
                if (SectionEditorPanel.this.mouseOverTable != null && !SectionEditorPanel.this.mouseOverTable.isLocked() && !SectionEditorPanel.this.mouseOverTable.hasAccount()) {
                    SectionEditorPanel.this.deleteTable.emit((Object)SectionEditorPanel.this.mouseOverTable);
                    SectionEditorPanel.this.repaint();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.isMyStateCurrent() && SectionEditorPanel.this.useMouseMovement && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                SectionEditorPanel.this.setMouseOverTable(SectionEditorPanel.this.getTableAt(SectionEditorPanel.this.mouseX, SectionEditorPanel.this.mouseY));
                SectionEditorPanel.this.setDraggedTable(null);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isMyStateCurrent() && SectionEditorPanel.this.useMouseMovement && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.clearMouseOverTable();
                SectionEditorPanel.this.repaint();
            }
        }
    }

    private class CreateMouseAdapter
    extends StateMouseAdapter {
        private CreateMouseAdapter() {
            this.setMyState(GTLMode.Create);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                int newTableX = SectionEditorPanel.this.mouseX - SectionEditorPanel.this.getProtoTypeNewTable().getTableImageWidth() / 2;
                int newTableY = SectionEditorPanel.this.mouseY - SectionEditorPanel.this.getProtoTypeNewTable().getTableImageHeight() / 2;
                SectionEditorPanel.this.setMouseOverTable(SectionEditorPanel.this.getIntersectingTable(newTableX, newTableY, SectionEditorPanel.this.getProtoTypeNewTable().getTableImageWidth(), SectionEditorPanel.this.getProtoTypeNewTable().getTableImageHeight()));
                if (SectionEditorPanel.this.mouseOverTable == null && SectionEditorPanel.this.tableGroupContainsRect(newTableX, newTableY, SectionEditorPanel.this.getProtoTypeNewTable().getTableImageWidth(), SectionEditorPanel.this.getProtoTypeNewTable().getTableImageHeight())) {
                    SectionEditorPanel.this.protoTypeNewTable.setX(newTableX);
                    SectionEditorPanel.this.protoTypeNewTable.setY(newTableY);
                    SectionEditorPanel.this.createTable.emit((Object)SectionEditorPanel.this.protoTypeNewTable);
                    SectionEditorPanel.this.repaint();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.isMyStateCurrent() && SectionEditorPanel.this.useMouseMovement && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                SectionEditorPanel.this.setDraggedTable(null);
                SectionEditorPanel.this.setMouseOverTable(SectionEditorPanel.this.getIntersectingTable(SectionEditorPanel.this.mouseX - SectionEditorPanel.this.getCurrentSelectedTableWidth() / 2, SectionEditorPanel.this.mouseY - SectionEditorPanel.this.getCurrentSelectedTableHeight() / 2, SectionEditorPanel.this.getProtoTypeNewTable().getTableImageWidth(), SectionEditorPanel.this.getProtoTypeNewTable().getTableImageHeight()));
                SectionEditorPanel.this.repaint();
            }
        }
    }

    private class MoveNoLinkMouseAdapter
    extends StateMouseAdapter {
        private MoveNoLinkMouseAdapter() {
            this.setMyState(GTLMode.MovePhysical);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.preMove.emit();
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                SectionEditorPanel.this.draggedPhysicalTable = SectionEditorPanel.this.getTableAt(SectionEditorPanel.this.mouseX, SectionEditorPanel.this.mouseY);
                if (SectionEditorPanel.this.draggedPhysicalTable != null) {
                    SectionEditorPanel.this.dragOffsetX = SectionEditorPanel.this.mouseX - SectionEditorPanel.this.draggedPhysicalTable.getX();
                    SectionEditorPanel.this.dragOffsetY = SectionEditorPanel.this.mouseY - SectionEditorPanel.this.draggedPhysicalTable.getY();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                if (SectionEditorPanel.this.draggedPhysicalTable != null) {
                    if (SectionEditorPanel.this.isGridEnabled()) {
                        SectionEditorPanel.this.snapMouseXY();
                    }
                    Rectangle draggedRect = SectionEditorPanel.this.draggedPhysicalTable.getRect();
                    int newXPos = SectionEditorPanel.this.forceInTableGroupBoundsX(SectionEditorPanel.this.mouseX - SectionEditorPanel.this.dragOffsetX, draggedRect.width);
                    int newYPos = SectionEditorPanel.this.forceInTableGroupBoundsY(SectionEditorPanel.this.mouseY - SectionEditorPanel.this.dragOffsetY, draggedRect.height);
                    newXPos = SectionEditorPanel.this.forceInBoundsX(newXPos, draggedRect.width);
                    newYPos = SectionEditorPanel.this.forceInBoundsY(newYPos, draggedRect.height);
                    SectionEditorPanel.this.draggedPhysicalTable.setPosition(newXPos, newYPos);
                    SectionEditorPanel.this.repaint();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.isMyStateCurrent() && SectionEditorPanel.this.useMouseMovement && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                SectionEditorPanel.this.setDraggedTable(null);
                SectionEditorPanel.this.draggedPhysicalTable = null;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                SectionEditorPanel.this.setMouseOverTable(SectionEditorPanel.this.getTableAt(SectionEditorPanel.this.mouseX, SectionEditorPanel.this.mouseY));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                if (SectionEditorPanel.this.draggedTable != null) {
                    SectionEditorPanel.this.setMouseOverTable(SectionEditorPanel.this.getIntersectingTable(SectionEditorPanel.this.draggedTable));
                    if (SectionEditorPanel.this.mouseOverTable != null) {
                        SectionEditorPanel.this.mouseOverTable = SectionEditorPanel.this.getTableGroup().getHelper().joinTables(SectionEditorPanel.this.mouseOverTable, SectionEditorPanel.this.draggedTable, SectionEditorPanel.this.gtl.isArrangeOnJoin());
                        if (SectionEditorPanel.this.mouseOverTable != null) {
                            SectionEditorPanel.this.tableJoined.emit();
                        } else {
                            SectionEditorPanel.this.draggedTable.setPosition(SectionEditorPanel.this.originalPtX, SectionEditorPanel.this.originalPtY);
                        }
                    } else {
                        SectionEditorPanel.this.tableMoved.emit();
                    }
                    if (SectionEditorPanel.this.interfaceLocked) {
                        SectionEditorPanel.this.draggedTable.setPosition(SectionEditorPanel.this.originalPtX, SectionEditorPanel.this.originalPtY);
                    }
                }
                SectionEditorPanel.this.setDraggedTable(null);
                SectionEditorPanel.this.dragOffsetX = (SectionEditorPanel.this.dragOffsetY = 0);
                SectionEditorPanel.this.setMouseOverTable(SectionEditorPanel.this.getTableAt(SectionEditorPanel.this.mouseX, SectionEditorPanel.this.mouseY));
                SectionEditorPanel.this.repaint();
            }
        }
    }

    private class MoveMouseAdapter
    extends StateMouseAdapter {
        private MoveMouseAdapter() {
            this.setMyState(GTLMode.Move);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.preMove.emit();
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                SectionEditorPanel.this.setMouseOverTable(SectionEditorPanel.this.getTableAt(SectionEditorPanel.this.mouseX, SectionEditorPanel.this.mouseY));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                int prevMouseX = SectionEditorPanel.this.mouseX;
                int prevMouseY = SectionEditorPanel.this.mouseY;
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                if (SectionEditorPanel.this.draggedTable != null) {
                    if (SectionEditorPanel.this.isGridEnabled()) {
                        SectionEditorPanel.this.snapMouseXY();
                    }
                    Rectangle draggedRect = SectionEditorPanel.this.draggedTable.getBoundingRect();
                    int newXPos = SectionEditorPanel.this.forceInTableGroupBoundsX(SectionEditorPanel.this.mouseX - SectionEditorPanel.this.dragOffsetX, draggedRect.width);
                    int newYPos = SectionEditorPanel.this.forceInTableGroupBoundsY(SectionEditorPanel.this.mouseY - SectionEditorPanel.this.dragOffsetY, draggedRect.height);
                    newXPos = SectionEditorPanel.this.forceInBoundsX(newXPos, draggedRect.width);
                    newYPos = SectionEditorPanel.this.forceInBoundsY(newYPos, draggedRect.height);
                    SectionEditorPanel.this.draggedTable.setPosition(newXPos, newYPos);
                    SectionEditorPanel.this.setMouseOverTable(SectionEditorPanel.this.getIntersectingTable(SectionEditorPanel.this.draggedTable));
                    SectionEditorPanel.this.repaint();
                } else if (SectionEditorPanel.this.mouseOverTable != null && !SectionEditorPanel.this.mouseOverTable.isLocked()) {
                    LogicalTable dragged;
                    PhysicalTable tableToSplit = SectionEditorPanel.this.getTableAt(prevMouseX, prevMouseY);
                    if (SectionEditorPanel.this.gtl.isArrangeOnJoin() && tableToSplit != null && !tableToSplit.equals((Object)SectionEditorPanel.this.mouseOverTable.getPrimaryPhysicalTable()) && (dragged = SectionEditorPanel.this.getTableGroup().getHelper().splitTable(SectionEditorPanel.this.mouseOverTable, tableToSplit, false)) != null) {
                        SectionEditorPanel.this.tableSplit.emit();
                        SectionEditorPanel.this.mouseOverTable = dragged;
                    }
                    SectionEditorPanel.this.setDraggedTable(SectionEditorPanel.this.mouseOverTable);
                    SectionEditorPanel.this.clearMouseOverTable();
                    SectionEditorPanel.this.dragOffsetX = SectionEditorPanel.this.mouseX - SectionEditorPanel.this.draggedTable.getX();
                    SectionEditorPanel.this.dragOffsetY = SectionEditorPanel.this.mouseY - SectionEditorPanel.this.draggedTable.getY();
                    SectionEditorPanel.this.originalPtX = SectionEditorPanel.this.mouseX - SectionEditorPanel.this.dragOffsetX;
                    SectionEditorPanel.this.originalPtY = SectionEditorPanel.this.mouseY - SectionEditorPanel.this.dragOffsetY;
                    SectionEditorPanel.this.repaint();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.isMyStateCurrent() && SectionEditorPanel.this.useMouseMovement && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                SectionEditorPanel.this.setDraggedTable(null);
                SectionEditorPanel.this.draggedPhysicalTable = null;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                SectionEditorPanel.this.setMouseOverTable(SectionEditorPanel.this.getTableAt(SectionEditorPanel.this.mouseX, SectionEditorPanel.this.mouseY));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                if (SectionEditorPanel.this.draggedTable != null) {
                    SectionEditorPanel.this.setMouseOverTable(SectionEditorPanel.this.getIntersectingTable(SectionEditorPanel.this.draggedTable));
                    if (SectionEditorPanel.this.mouseOverTable != null) {
                        SectionEditorPanel.this.mouseOverTable = SectionEditorPanel.this.getTableGroup().getHelper().joinTables(SectionEditorPanel.this.mouseOverTable, SectionEditorPanel.this.draggedTable, true);
                        if (SectionEditorPanel.this.mouseOverTable != null) {
                            SectionEditorPanel.this.tableJoined.emit();
                        } else {
                            SectionEditorPanel.this.draggedTable.setPosition(SectionEditorPanel.this.originalPtX, SectionEditorPanel.this.originalPtY);
                        }
                    } else {
                        SectionEditorPanel.this.tableMoved.emit();
                    }
                    if (SectionEditorPanel.this.interfaceLocked) {
                        SectionEditorPanel.this.draggedTable.setPosition(SectionEditorPanel.this.originalPtX, SectionEditorPanel.this.originalPtY);
                    }
                }
                SectionEditorPanel.this.setDraggedTable(null);
                SectionEditorPanel.this.dragOffsetX = (SectionEditorPanel.this.dragOffsetY = 0);
                SectionEditorPanel.this.setMouseOverTable(SectionEditorPanel.this.getTableAt(SectionEditorPanel.this.mouseX, SectionEditorPanel.this.mouseY));
                SectionEditorPanel.this.repaint();
            }
        }
    }

    private class UnLinkMouseAdapter
    extends StateMouseAdapter {
        private UnLinkMouseAdapter() {
            this.setMyState(GTLMode.Unlink);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                SectionEditorPanel.this.fromTable = SectionEditorPanel.this.getTableAt(SectionEditorPanel.this.mouseX, SectionEditorPanel.this.mouseY);
                if (SectionEditorPanel.this.fromTable.getLogicalTable().getNumberOfTables() > 1) {
                    try {
                        SectionEditorPanel.this.getTableGroup().getHelper().splitTable(SectionEditorPanel.this.fromTable.getLogicalTable(), SectionEditorPanel.this.fromTable, false);
                        SectionEditorPanel.this.tableSplit.emit();
                        SectionEditorPanel.this.repaint();
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.log(Level.WARN, "Cannot split ", (Throwable)ex);
                    }
                }
            }
        }
    }

    private class LinkMouseAdapter
    extends StateMouseAdapter {
        private LinkMouseAdapter() {
            this.setMyState(GTLMode.Link);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                SectionEditorPanel.this.originalPtX = SectionEditorPanel.this.mouseX;
                SectionEditorPanel.this.originalPtY = SectionEditorPanel.this.mouseY;
                SectionEditorPanel.this.fromTable = SectionEditorPanel.this.getTableAt(SectionEditorPanel.this.mouseX, SectionEditorPanel.this.mouseY);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked() && SectionEditorPanel.this.fromTable != null) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                if (SectionEditorPanel.this.fromTable != null) {
                    SectionEditorPanel.this.repaint();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                if (SectionEditorPanel.this.fromTable != null) {
                    LogicalTable joined;
                    SectionEditorPanel.this.originalPtX = SectionEditorPanel.this.mouseX;
                    SectionEditorPanel.this.originalPtY = SectionEditorPanel.this.mouseY;
                    SectionEditorPanel.this.mouseX = e.getX();
                    SectionEditorPanel.this.mouseY = e.getY();
                    PhysicalTable toTable = SectionEditorPanel.this.getTableAt(SectionEditorPanel.this.mouseX, SectionEditorPanel.this.mouseY);
                    if (toTable != null && !toTable.equals((Object)SectionEditorPanel.this.fromTable) && (joined = SectionEditorPanel.this.getTableGroup().getHelper().joinTables(toTable.getLogicalTable(), SectionEditorPanel.this.fromTable.getLogicalTable(), SectionEditorPanel.this.gtl.isArrangeOnJoin())) != null) {
                        SectionEditorPanel.this.tableJoined.emit();
                    }
                }
                SectionEditorPanel.this.fromTable = null;
                SectionEditorPanel.this.repaint();
            }
        }
    }

    private class SelectMouseAdapter
    extends StateMouseAdapter {
        private SelectMouseAdapter() {
            this.setMyState(GTLMode.Select);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.isMyStateCurrent() && !SectionEditorPanel.this.isInterfaceLocked()) {
                SectionEditorPanel.this.mouseX = e.getX();
                SectionEditorPanel.this.mouseY = e.getY();
                SectionEditorPanel.this.setMouseOverTable(SectionEditorPanel.this.getTableAt(SectionEditorPanel.this.mouseX, SectionEditorPanel.this.mouseY));
                if (SectionEditorPanel.this.mouseOverTable != null) {
                    SectionEditorPanel.this.tableSelected.emit((Object)SectionEditorPanel.this.mouseOverTable);
                }
                SectionEditorPanel.this.repaint();
            }
        }
    }

    private abstract class StateMouseAdapter
    extends MouseInputAdapter {
        protected GTLMode myMode;

        private StateMouseAdapter() {
        }

        protected void setMyState(GTLMode mode) {
            this.myMode = mode;
        }

        protected final boolean isMyStateCurrent() {
            return SectionEditorPanel.this.gtlMode == this.myMode;
        }
    }
}

