/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.tablelayout;

import au.com.ordermate.util.image.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.misc.SystemProperty;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.guikit.components.CustomCheckButton;
import waitermate.guikit.dialogs.OnePressPopupWindow;

public class TableImageSelector
extends OnePressPopupWindow {
    private JPanel tableOrderablePanel;
    private CustomCheckButton tableOrderableCheck;
    private static final int NUM_COLS = 5;
    private static final int NUM_ROWS = 5;
    private final Map<String, ImageIcon> tableImages = SystemProperty.getInstance().getTableImages();
    private String selectedKey;

    public TableImageSelector() {
        super("Select an image", TableImageSelector.constructButtons(SystemProperty.getInstance().getTableImages()), 5, 5);
        this.installCustomFeatures();
    }

    private void installCustomFeatures() {
        this.tableOrderablePanel = new JPanel();
        JLabel canOrderLabel = new JLabel("Can Order to Table?");
        canOrderLabel.setFont(OrderMateTheme.getLargeFont());
        this.tableOrderablePanel.add(canOrderLabel);
        this.tableOrderableCheck = new CustomCheckButton();
        this.tableOrderablePanel.add((Component)this.tableOrderableCheck);
        this.tableOrderableCheck.setSelected(true);
        Component oldSouthComp = ((BorderLayout)this.getParentWindow().getLayout()).getLayoutComponent("South");
        JPanel holder = new JPanel();
        holder.setLayout(new BoxLayout(holder, 1));
        holder.add(oldSouthComp);
        holder.add(Box.createVerticalStrut(5));
        holder.add(this.tableOrderablePanel);
        this.getParent().add((Component)holder, "South");
    }

    private static Collection constructButtons(Map<String, ImageIcon> map) {
        int iconWidth = 120;
        int iconHeight = 80;
        ArrayList<JButton> buttons = new ArrayList<JButton>(map.size());
        ImageHelper helper = new ImageHelper();
        for (String key : map.keySet()) {
            Image toAdd = helper.fitImageTo(map.get(key).getImage(), 120, 80);
            ImageIcon newSizedIcon = new ImageIcon(toAdd);
            JButton newButton = new JButton(newSizedIcon);
            newButton.setName(key);
            buttons.add(newButton);
        }
        return buttons;
    }

    public JButton start() {
        JButton selectedBtn = super.start();
        this.selectedKey = selectedBtn.getName();
        return selectedBtn;
    }

    public Icon getSelectedImage() {
        return this.tableImages.get(this.selectedKey);
    }

    public String getSelectedImagePath() {
        return this.selectedKey;
    }

    public boolean isCanOrderToTable() {
        return this.tableOrderableCheck.isSelected();
    }

    public void setShowIsCanOrderToTable(boolean value) {
        this.tableOrderablePanel.setVisible(value);
    }
}

