/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.tablelayout.tablestate;

import ordermate.database.EventContext;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.LogicalTableState;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.tablelayout.TableModifier;

public class TableStateModifier
implements TableModifier {
    private final LogicalTableState state;
    private final EventContext context;

    public TableStateModifier(LogicalTableState theState, EventContext context) {
        this.state = theState;
        this.context = context;
    }

    @Override
    public boolean performActionOnTable(LogicalTable table) {
        if (!table.isLocked()) {
            WaitermateSaveAccount.getInstance().setTableState(this.state, table, this.context, true);
            return true;
        }
        return false;
    }

    @Override
    public String getFailure() {
        return Internationalization.getLiteralFor((String)"THIS_TABLE_IS_LOCKED_BY_ANOTHER_USER");
    }

    @Override
    public String getSuccess() {
        return null;
    }

    @Override
    public String getTitle() {
        if (this.state == null) {
            return Internationalization.getLiteralFor((String)"CLEAR_TABLE_STATE");
        }
        return Internationalization.getLiteralFor((String)"CHANGE_TABLE_STATE_TO") + " " + this.state.getLabel();
    }
}

