/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.tablelayout.tablestate;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.tables.LogicalTableState;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.tablelayout.tablestate.TableStateRenderer;

public class TableStatePanel
extends JPanel {
    public Signal<LogicalTableState, ?, ?, ?, ?> stateChanged = Signals.createSignal(LogicalTableState.class, (String)"newState");
    private CustomScrollPane buttonScroll;
    private RendererScrollPaneModel<LogicalTableState> model;
    private boolean showingCourseStates = true;

    public TableStatePanel() {
        super(new BorderLayout());
        TableStateRenderer renderer = new TableStateRenderer();
        renderer.selected.connect((Object)this, "gotSelectedId");
        this.model = new RendererScrollPaneModel((Renderer)renderer, 1, 6);
        this.buildSelectionList(true);
        this.buttonScroll = new CustomScrollPane(this.model);
        JLabel label = new JLabel(Internationalization.getLiteralFor((String)"PLEASE_SELECT_A_STATE"));
        this.add((Component)label, "North");
        this.add((Component)this.buttonScroll, "Center");
    }

    public void gotSelectedId(Long value) {
        if (value != null) {
            LogicalTableState state = (LogicalTableState)PersistenceManager.getByID((long)value, LogicalTableState.class);
            if (state != null) {
                this.stateChanged.emit((Object)state);
            }
        } else {
            this.stateChanged.emit(null);
        }
    }

    private void buildSelectionList(boolean showCourseStates) {
        ObjectQuery statesQry = Query.select(LogicalTableState.class).orderBy(LogicalTableState.Properties.SEQUENCE);
        if (!showCourseStates) {
            statesQry.isNull(LogicalTableState.Properties.COURSE);
        }
        List states = PersistenceManager.getObjectList(LogicalTableState.class, (String)statesQry.toString(), null);
        LogicalTableState clearState = new LogicalTableState();
        clearState.setLabel(Internationalization.getLiteralFor((String)"CLEAR_STATE"));
        states.add(0, clearState);
        this.model.setObjects(states);
    }

    public void showStatesLinkedToCourses(boolean showCourseStates) {
        if (this.showingCourseStates != showCourseStates) {
            this.buildSelectionList(showCourseStates);
            this.showingCourseStates = showCourseStates;
        }
    }
}

