/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.tablelayout.tablestate;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import ordermate.database.tables.LogicalTableState;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class TableStateRenderer
implements Renderer<JButton, LogicalTableState> {
    private static final String CLEAR = "clearState";
    Signal<Long, ?, ?, ?, ?> selected = Signals.createSignal(Long.class, (String)"ID");

    public JButton createComponent() {
        final JButton button = new JButton();
        OrderMateTheme.setupTouchScreenButton((AbstractButton)button);
        button.setHorizontalTextPosition(4);
        button.setHorizontalAlignment(2);
        button.setPreferredSize(new Dimension(400, 120));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (button.getName() != TableStateRenderer.CLEAR) {
                    TableStateRenderer.this.selected.emit((Object)Long.valueOf(button.getName()));
                } else {
                    TableStateRenderer.this.selected.emit(null);
                }
            }
        });
        return button;
    }

    public void setupComponent(JButton component, LogicalTableState object, int index) {
        if (object.getID() == null) {
            component.setName(CLEAR);
        } else {
            component.setName("" + object.getID());
        }
        component.setText(object.getLabel());
        component.setBackground(object.getColour());
        ImageIcon icon = null;
        if (object.getIcon() != null) {
            icon = IconLoader.get((String)object.getIcon());
        }
        component.setIcon(icon);
    }
}

