/*
 * Decompiled with CFR 0.152.
 */
package waitermate.hardware.posiflex;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import ordermate.OrderMate;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import posiflex.PosiflexRFIDWrapper;

public class PosiflexRFIDReader {
    private static final int success = 0;
    private static final int fail = 1;
    static String[] dllsRequired = new String[]{"PFXRFID.DLL", "PosiflexRFIDWrapper.dll", "libgcc_s_dw2-1.dll"};
    private static volatile PosiflexRFIDReader instance = null;
    public final Signal<String, ?, ?, ?, ?> stateChangeSignal = Signals.createSignal(String.class, (String)"input");
    private ReaderThread reader;
    private Thread thread;
    private PosiflexRFIDWrapper wrapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PosiflexRFIDReader getInstance() {
        if (instance != null) return instance;
        Class<PosiflexRFIDReader> clazz = PosiflexRFIDReader.class;
        synchronized (PosiflexRFIDReader.class) {
            if (instance != null) return instance;
            instance = new PosiflexRFIDReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    static void setInstance(PosiflexRFIDReader reader) {
        instance = reader;
    }

    private PosiflexRFIDReader() {
        this.createDllsIfRequired();
        this.wrapper = new PosiflexRFIDWrapper();
    }

    void createDllsIfRequired() {
        String userDir = System.getProperty("user.dir");
        for (String nextDll : dllsRequired) {
            File theFile = new File(userDir + File.separator + nextDll);
            if (theFile.exists()) continue;
            this.copyToDisk(nextDll, theFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToDisk(String dllName, File location) {
        InputStream input = this.getClass().getResourceAsStream("/dlls/" + dllName);
        OutputStream fout = null;
        if (input != null) {
            try {
                location.createNewFile();
                fout = new FileOutputStream(location);
                int nextByte = input.read();
                while (nextByte >= 0) {
                    ((FileOutputStream)fout).write(nextByte);
                    nextByte = input.read();
                }
            }
            catch (IOException ex) {
                OrderMate.LOG.error("Cannot write required dlls:" + ex);
            }
            finally {
                try {
                    if (fout != null) {
                        fout.flush();
                        ((FileOutputStream)fout).close();
                    }
                    input.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Problem closing off the input or output files:" + ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startReading() {
        PosiflexRFIDReader posiflexRFIDReader = this;
        synchronized (posiflexRFIDReader) {
            this.createAndStart();
        }
        return true;
    }

    private void createAndStart() {
        if (this.reader != null) {
            this.reader.finishUp();
        }
        this.reader = new ReaderThread();
        this.thread = new Thread(this.reader);
        this.thread.start();
    }

    public boolean isStarted() {
        return this.thread != null && this.thread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReading() {
        PosiflexRFIDReader posiflexRFIDReader = this;
        synchronized (posiflexRFIDReader) {
            if (this.reader == null) {
                this.createAndStart();
            }
            this.reader.finishUp();
            try {
                this.thread.join(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    class ReaderThread
    implements Runnable {
        private boolean run = true;
        private final int timeout = 1000;
        private byte[] buffer = new byte[512];
        private String previousResult = null;

        ReaderThread() {
        }

        @Override
        public void run() {
            int result = 0;
            OrderMate.LOG.info("Opening Posiflex RFID Reader...");
            result = PosiflexRFIDReader.this.wrapper.openReader();
            if (result == 1) {
                result = PosiflexRFIDReader.this.wrapper.closeReader();
                result = PosiflexRFIDReader.this.wrapper.openReader();
                if (result == 1) {
                    OrderMate.LOG.error("Posiflex open card reader failed!!!");
                    this.run = false;
                }
            }
            while (this.run) {
                result = PosiflexRFIDReader.this.wrapper.connectCard();
                result = PosiflexRFIDReader.this.wrapper.chkCard(this.buffer, 1000);
                if (result == 0) {
                    String newResult = this.convertDataToHex(this.buffer);
                    if (!newResult.equals(this.previousResult)) {
                        OrderMate.LOG.info("Posiflex RFID Scanner - New Result: " + newResult);
                        this.previousResult = newResult;
                        PosiflexRFIDReader.this.stateChangeSignal.emit((Object)newResult);
                    }
                } else {
                    this.previousResult = null;
                }
                result = PosiflexRFIDReader.this.wrapper.disconnect();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            OrderMate.LOG.info("Closing Posiflex RFID Reader...");
            PosiflexRFIDReader.this.wrapper.closeReader();
        }

        private String convertDataToHex(byte[] buffer2) {
            ByteBuffer bb = ByteBuffer.wrap(buffer2);
            return Integer.toHexString(bb.getInt());
        }

        void finishUp() {
            this.run = false;
        }
    }
}

