/*
 * Decompiled with CFR 0.152.
 */
package waitermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import java.io.IOException;
import java.util.List;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.ProximityReader;
import ordermate.gui.InputAdapterFactory;
import ordermate.startup.OrderMateSetupException;
import waitermate.WaiterMateInputAdapter;

public class ProximityReaderSetupTask
extends AbstractTask {
    public final int getTotalSubTasks() {
        return 1;
    }

    public final String getName() {
        return "Setting up proximity readers";
    }

    public final void performTask() throws Exception {
        List proximityReaders = Terminal.getLocalHost().getAvailableProximityReaders();
        for (ProximityReader reader : proximityReaders) {
            try {
                reader.startup(Terminal.getLocalHost());
            }
            catch (IOException e) {
                throw new OrderMateSetupException((Task)this, "Cannot communicate with Proximity Reader \"" + reader.getLabel() + "\"", new String[]{"Check that the proximity reader is plugged in to " + reader.getPort()}, (Throwable)e, true);
            }
        }
        ((WaiterMateInputAdapter)InputAdapterFactory.getAdapter()).setupProximityReaders();
        this.emitProgress();
    }
}

