/*
 * Decompiled with CFR 0.152.
 */
package waitermate.startup;

import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.serverconnection.ConnectionManagerScreen;
import ordermate.serverconnection.ManagerScreenWrapper;
import ordermate.startup.ManagerStartupTask;
import waitermate.guikit.WaitermateConnectionPanel;

public class WaiterMateManagerStartupTask
extends ManagerStartupTask {
    private ManagerScreenWrapper wrapper;

    public WaiterMateManagerStartupTask(String theTerminalType) {
        super(theTerminalType);
    }

    protected void performTask() {
        try {
            this.initializeScreen();
            this.wrapper.showConnectionInterface();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error creating connection screen " + this.wrapper, (Throwable)ex);
        }
        super.performTask();
    }

    protected boolean shouldRetry(int currentTryCount) {
        return true;
    }

    protected void handleRetryFailed(int currentTryCount, String server, Exception e) throws InterruptedException {
        this.wrapper.setNumRetries(server, currentTryCount);
        OrderMate.LOG.warn("Retrying to connect to " + server + " for " + currentTryCount + " attempt(s)...", (Throwable)e);
        Thread.sleep(1000L);
    }

    protected void doStartupSuccessful() {
        this.wrapper.hideConnectionInterface();
        super.doStartupSuccessful();
    }

    private void initializeScreen() throws Exception {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    WaitermateConnectionPanel screen = new WaitermateConnectionPanel();
                    WaiterMateManagerStartupTask.this.wrapper = new ManagerScreenWrapper((ConnectionManagerScreen)screen);
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Error creating connection screen " + WaiterMateManagerStartupTask.this.wrapper, (Throwable)ex);
                }
            }
        });
    }
}

