/*
 * Decompiled with CFR 0.152.
 */
package waitermate.upsell;

import java.util.List;
import ordermate.database.Sequenced;
import ordermate.database.misc.resource.ConfigResource;
import ordermate.database.sales.SalesItem;
import ordermate.database.upsell.UpsellSuggestion;

public class Upsell
implements Sequenced {
    private final UpsellSuggestion suggestion;
    private final SalesItem salesItem;
    private final ConfigResource chosenResource;
    private String label;

    Upsell(SalesItem item, UpsellSuggestion theSuggestion) {
        this.salesItem = item;
        this.suggestion = theSuggestion;
        StringBuilder SB = new StringBuilder();
        if (this.salesItem != null) {
            SB.append(this.salesItem.getLabel()).append(" ");
        }
        SB.append(this.suggestion.getDescription());
        this.label = SB.toString();
        this.chosenResource = this.chooseResource();
    }

    private ConfigResource chooseResource() {
        ConfigResource theOne = null;
        List resources = this.suggestion.getResourceSet().getResources();
        theOne = !resources.isEmpty() ? (resources.size() == 1 ? (ConfigResource)resources.get(0) : (ConfigResource)resources.get((int)(Math.random() * (double)resources.size()))) : null;
        return theOne;
    }

    public UpsellSuggestion getSuggestion() {
        return this.suggestion;
    }

    public SalesItem getSalesItem() {
        return this.salesItem;
    }

    public String toString() {
        return this.label;
    }

    public ConfigResource getResource() {
        return this.chosenResource;
    }

    public int compareTo(Object o) {
        if (o instanceof Sequenced) {
            return ((Sequenced)o).getSequence() - this.getSequence();
        }
        return 0;
    }

    public int getSequence() {
        return this.suggestion.getSequence();
    }
}

