/*
 * Decompiled with CFR 0.152.
 */
package waitermate.webpayment;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.Payable;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.integration.webpayment.WebPaymentCustomer;
import ordermate.database.integration.webpayment.WebPaymentType;
import ordermate.database.sales.BarTabAccount;
import ordermate.integration.bartabs.BarTabAdministrator;
import ordermate.integration.bartabs.BarTabSettlementResult;
import ordermate.internationalization.Internationalization;
import ordermate.services.finance.transactions.FinanceTransactionFactory;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.screens.payment.eftpos.EftposController;
import waitermate.gui.screens.payment.paypaltransaction.WebTransactionPanel;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;
import waitermate.guikit.dialogs.ProgressDialog;
import waitermate.webpayment.AbsorbWebPaymentCustomerDetailsWorker;
import waitermate.webpayment.WebPaymentSelection;

public class WaitermateWebPayment {
    private WebPaymentCustomer selectedCustomer = null;
    private WebPaymentSelection customerSelection;
    private WebTransactionPanel gui;
    private PopupWindow window;
    private Payable payableObject;
    private Price paid;
    private Price tip;
    private PopupWindow confirmation;
    private EftposController controller;
    public Signal<FinanceTransaction, ?, ?, ?, ?> done = Signals.createSignal(FinanceTransaction.class, (String)"txn");

    public WaitermateWebPayment() {
        this.window = new PopupWindow();
        this.gui = new WebTransactionPanel();
        this.gui.paidSelected.connect((Object)this, "gotPaid");
        this.gui.tipSelected.connect((Object)this, "gotTip");
        this.window.setPreferredSize(new Dimension(500, 400));
        this.window.getNavBar().getCancelButton().setText("Cancel");
        this.window.add((Component)this.gui);
    }

    private void updateGUI() {
        this.gui.setDetails(this.getDue(), this.paid, this.tip);
    }

    private void setupIcon(WebPaymentType paymentType) {
        if (WebPaymentType.PayPal.equals((Object)paymentType)) {
            this.window.getNavBar().setImage("/waitermate/images/partners/paypal-logo.png");
        } else if (WebPaymentType.BarTabPartner.equals((Object)paymentType)) {
            this.window.getNavBar().setImage(null);
        }
    }

    public void startProcess(Payable payable, WebPaymentType paymentType) {
        this.payableObject = payable;
        this.paid = this.getDue();
        this.tip = Price.ZERO_DOLLAR;
        this.gui.setDetails(this.getDue(), this.paid, this.tip);
        if (WebPaymentType.BarTabPartner.equals((Object)paymentType)) {
            this.gui.setPaidEnabled(this.payableObject.isPaidModifiable() && BarTabAdministrator.getInstance().isPartialSettlementAllowed((BarTabAccount)payable));
            this.gui.setTipEnabled(BarTabAdministrator.getInstance().isTippingAllowed((BarTabAccount)payable));
        } else {
            this.gui.setPaidEnabled(this.payableObject.isPaidModifiable());
            this.gui.setTipEnabled(true);
        }
        this.setupIcon(paymentType);
        boolean result = this.window.start();
        if (result && this.paid != null && !this.paid.isZero()) {
            if (WebPaymentType.PayPal.equals((Object)paymentType)) {
                this.customerSelection = new WebPaymentSelection();
                this.customerSelection.gotCustomer.connect((Object)this, "gotCustomer");
                this.customerSelection.start();
            } else if (WebPaymentType.BarTabPartner.equals((Object)paymentType)) {
                this.doBarTabPayment(payable);
            }
        }
    }

    public void startQuicksaleProcess(Payable payable, WebPaymentType type) {
        this.payableObject = payable;
        this.paid = this.getDue();
        this.tip = Price.ZERO_DOLLAR;
        if (this.paid != null && !this.paid.isZero() && WebPaymentType.PayPal.equals((Object)type)) {
            this.customerSelection = new WebPaymentSelection();
            this.customerSelection.gotCustomer.connect((Object)this, "gotCustomer");
            this.customerSelection.start();
        }
    }

    private PopupWindow getConfirmation() {
        JLabel image;
        Image roundedImage;
        PopupWindow confirm = new PopupWindow();
        confirm.setText("Confirm payment?");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel name = new JLabel("<html><h2>" + this.selectedCustomer.getLabel() + "</h2></html>");
        name.setHorizontalAlignment(0);
        JPanel namePanel = new JPanel();
        namePanel.add(name);
        panel.add(namePanel);
        ImageHelper helper = new ImageHelper();
        if (this.selectedCustomer.getImage().getImage() != null) {
            roundedImage = this.selectedCustomer.getImage().getImage();
            roundedImage = helper.roundCorners(roundedImage, 10);
            image = new JLabel(new ImageIcon(roundedImage), 0);
            JPanel imagePanel = new JPanel();
            imagePanel.add(image);
            panel.add(imagePanel);
        } else {
            roundedImage = IconLoader.get((String)"/waitermate/images/missingCustomer.png").getImage();
            roundedImage = helper.roundCorners(roundedImage, 10);
            image = new JLabel(new ImageIcon(roundedImage), 0);
            JPanel imagePanel = new JPanel();
            imagePanel.add(image);
            panel.add(imagePanel);
        }
        JLabel total = new JLabel("<html><div style=\"text-align: center;\"><h2>Charge " + this.getPriceToPay().toString(true) + " to " + this.selectedCustomer.getLabel() + "<br> using PayPal?</h2></html>");
        total.setHorizontalAlignment(0);
        JPanel totalPanel = new JPanel();
        totalPanel.add(total);
        panel.add(totalPanel);
        confirm.add((Component)panel);
        confirm.getNavBar().ok.connect((Object)this, "gotConfirmed");
        confirm.getNavBar().cancel.connect((Object)this, "gotCancelled");
        return confirm;
    }

    private Price getPriceToPay() {
        return this.paid.add(this.tip);
    }

    protected Price getDue() {
        return this.payableObject.getDue();
    }

    public void gotPaid() {
        double newPaid = Dialogs.getDouble((String)(Internationalization.getLiteralFor((String)"PAID") + " " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN")));
        if (newPaid != Double.MIN_VALUE) {
            this.paid = new Price(newPaid, 0.01);
            this.updateGUI();
        }
    }

    public void gotTip() {
        double newTip = Dialogs.getDouble((String)(Internationalization.getLiteralFor((String)"TIP") + " " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN")));
        if (newTip != Double.MIN_VALUE) {
            this.tip = new Price(newTip, 0.01);
            this.updateGUI();
        }
    }

    public void gotCustomer(WebPaymentCustomer customer) {
        this.selectedCustomer = customer;
        if (this.selectedCustomer != null && this.selectedCustomer.isCheckedIn() && !this.selectedCustomer.isExpired() && this.selectedCustomer.isPersistent() && this.payableObject != null) {
            Price oldDue = this.payableObject.getDue();
            AbsorbWebPaymentCustomerDetailsWorker absorber = new AbsorbWebPaymentCustomerDetailsWorker();
            absorber.absorb(this.payableObject, this.selectedCustomer, LoginManager.getEventContext());
            if (!oldDue.equals((Object)this.payableObject.getDue()) && (this.paid.greaterThan((Object)this.payableObject.getDue()) || this.paid.equals((Object)oldDue))) {
                this.paid = this.getDue();
                this.updateGUI();
            }
            this.customerSelection.gotDone.emit();
            this.confirmation = this.getConfirmation();
            this.confirmation.start();
        }
    }

    private EftposController getController() {
        if (this.controller == null) {
            this.controller = new EftposController();
            this.controller.txnAdded.connect((Object)this, "gotEftposAdded");
            this.controller.txnRemoved.connect((Object)this, "gotEftposRemoved");
            this.controller.eftposFinished.connect((Object)this, "gotEftposFinished");
        }
        return this.controller;
    }

    public void gotConfirmed() {
        this.confirmation.setVisible(false);
        FinanceTransactionFactory ftf = new FinanceTransactionFactory();
        WebTransaction txn = ftf.createWebTransaction(LoginManager.getEventContext(), this.paid, this.tip, FinanceUnit.getDefaultUnitFor((FinanceUnit.FinanceUnitType)FinanceUnit.WEB_TYPE));
        this.getController().performWebPayment(txn, this.payableObject, this.selectedCustomer);
    }

    public void gotCancelled() {
        this.customerSelection.start();
    }

    public void gotEftposAdded(EftposTransaction added) {
    }

    public void gotEftposRemoved(EftposTransaction removed) {
    }

    public void gotEftposFinished(EftposTransaction modified) {
        this.disconnect();
        this.done.emit((Object)modified);
    }

    private void disconnect() {
        if (this.controller != null) {
            this.controller.eftposFinished.disconnect((Object)this);
            this.controller.txnAdded.disconnect((Object)this);
            this.controller.txnRemoved.disconnect((Object)this);
            this.controller = null;
        }
    }

    private void doBarTabPayment(final Payable payable) {
        ProgressDialog.doProgressDialog((Task)new AbstractTask(){

            protected int getTotalSubTasks() {
                return 1;
            }

            public String getName() {
                return "Requesting Bar Tab Payment";
            }

            protected void performTask() throws Exception {
                BarTabSettlementResult settlementResult = BarTabAdministrator.getInstance().requestSettleBarTabAtPOS((BarTabAccount)payable, WaitermateWebPayment.this.paid, LoginManager.getInstance().getUser());
                if (settlementResult == null || !settlementResult.isSuccessful()) {
                    WaitermateGuiHandler guiHandler = new WaitermateGuiHandler();
                    guiHandler.displayOkDialog("Error occurred while requesting settlement." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Settlement could not be completed, please try again.", "Error Occured While Requesting Settlement");
                } else {
                    WaitermateWebPayment.this.gotEftposFinished((EftposTransaction)settlementResult.getFinanceTransaction());
                }
                this.emitProgress();
            }
        });
    }
}

