/*
 * Decompiled with CFR 0.152.
 */
package waitermate.webpayment;

import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import ordermate.database.integration.webpayment.WebPaymentCustomer;
import ordermate.gui.scroll.Renderer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class WebCustomerRenderer
implements Renderer<WebCustomerButton, WebPaymentCustomer> {
    private TimeZone defaultTimeZone = TimeZone.getDefault();
    private static final Dimension MAX_ICON_SIZE = new Dimension(100, 100);
    public Signal<WebPaymentCustomer, ?, ?, ?, ?> gotCustomer = Signals.createSignal(WebPaymentCustomer.class, (String)"customer");

    public WebCustomerButton createComponent() {
        return new WebCustomerButton();
    }

    public void setupComponent(WebCustomerButton component, WebPaymentCustomer object, int index) {
        component.setWebPaymentCustomer(object);
    }

    class WebCustomerButton
    extends JButton
    implements ActionListener {
        private WebPaymentCustomer customer;

        private WebCustomerButton() {
            this.addActionListener(this);
            this.setBackground(Color.DARK_GRAY);
            this.setOpaque(true);
            this.setBorderPainted(true);
            this.setContentAreaFilled(true);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
        }

        void setWebPaymentCustomer(WebPaymentCustomer webCustomer) {
            this.customer = webCustomer;
            if (this.customer == null) {
                this.setVisible(false);
            } else {
                this.setText("<html><center>" + this.customer.getLabel() + "<br>" + this.getCustomerCheckedInTime(webCustomer) + "</center></html>");
                ImageHelper helper = new ImageHelper();
                Image toDisplay = this.customer.getImage().getByteLength() < 1L ? IconLoader.get((String)"/waitermate/images/missingCustomer.png").getImage() : this.customer.getImage().getImage();
                toDisplay = helper.fitImageTo(toDisplay, MAX_ICON_SIZE.width, MAX_ICON_SIZE.height);
                toDisplay = helper.roundCorners(toDisplay, 10);
                this.setIcon(new ImageIcon(toDisplay));
            }
        }

        private String getCustomerCheckedInTime(WebPaymentCustomer webCustomer) {
            long difference = System.currentTimeMillis() - webCustomer.getCreateDate().getTime();
            long offset = WebCustomerRenderer.this.defaultTimeZone.getRawOffset();
            Date toReturn = new Date(difference - offset);
            Calendar creation = Calendar.getInstance();
            creation.setTime(toReturn);
            StringBuilder sb = new StringBuilder();
            if (creation.get(5) != 1) {
                sb.append(String.valueOf(creation.get(5) - 1)).append("d ");
            }
            if (creation.get(10) != 0) {
                sb.append(String.valueOf(creation.get(10)) + "h ");
            }
            if (creation.get(12) != 0) {
                sb.append(String.valueOf(creation.get(12)) + "m");
            }
            return sb.toString();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.customer != null) {
                WebCustomerRenderer.this.gotCustomer.emit((Object)this.customer);
            }
        }
    }
}

